// Profiler.h: interface for the Profiler class.
//
// this class can be used to profile functions
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PROFILER_H__ED8D57E8_94EF_4DE3_8893_81695E9176E9__INCLUDED_)
#define AFX_PROFILER_H__ED8D57E8_94EF_4DE3_8893_81695E9176E9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define MAXENTRY 100

class Profiler  
{
public:
	void selectDisplayItem(int item);
	bool enumProfiler(char *returnString);

	// to add the blocks
	void closeParentGroup();
	void addProfilerBlock(CString name, bool isGroup);

	// start and stop timing
	inline void Profiler::startTiming(int blockIndex)
	{
		if(blockIndex == -1|| blockIndex >= maxIndex)
			return;

		 ::QueryPerformanceCounter(&profilerBlock[blockIndex].startTime);

	}

	inline void Profiler::stopTiming(int blockIndex)
	{
		if(blockIndex == -1 || blockIndex >= maxIndex)
			return;

		 ::QueryPerformanceCounter(&profilerBlock[blockIndex].endTime);

		  profilerBlock[blockIndex].quantaTime += (double)(profilerBlock[blockIndex].endTime.QuadPart-profilerBlock[blockIndex].startTime.QuadPart)/(double)Frequency.QuadPart - timingOffset;
		  profilerBlock[blockIndex].totalTime += profilerBlock[blockIndex].quantaTime;
		  profilerBlock[blockIndex].quantaPerRun++;

	}

	int getTimeBlockIndex(CString name); // get the block index given the name
	int maxIndex;  // the number of current indexes

	// used when creating the profile blocks heiarchy
	int addCurrentParent;
	int addPrevBlock;

	// which item to display
	int currDisplayBlock;
	int enumIndex;

	double timingOffset; // the offset because profiling takes a bit of time


	struct ProfilerBlock
	{
		CString name;
		LARGE_INTEGER startTime,endTime;
		double totalTime;
		double quantaTime;
		int quantaPerRun; // how many times it runs per display
		int parentIndex;
		int siblingIndex;
		int childIndex;
		int currIndex;
	}

	profilerBlock[MAXENTRY];
	int nextFreeBlock; // tracks the next free block
	int currAddHeirachy; // tracks the heirachy e.g parent pointer

	



	inline void EnterStartTime()
	{
		::QueryPerformanceCounter(&oneTimeStart);
	/*	for (int ix = 0; ix < MaxIndex; ix++)
		{
			if (Name == Entries[ix].Name)
			{
				  ::QueryPerformanceCounter(&Entries[ix].starttime);
				  break;
			}
		}
		if (ix < MAXENTRY)
		{
			Entries[ix].Name = Name;
			::QueryPerformanceCounter(&Entries[ix].starttime);
			MaxIndex++;
		}*/
		
	}

	inline void EnterEndTime()
	{
		::QueryPerformanceCounter(&oneTimeEnd);
	/*	for (int ix = 0; ix < MaxIndex; ix++)
		{
			if (Name == Entries[ix].Name)
			{
				  ::QueryPerformanceCounter(&Entries[ix].endtime);
				  break;
			}
		}*/

	}

		inline void EnterEndTime(CString Name)
	{

	}

			inline void EnterStartTime(CString Name)
	{

	}

	inline double GetExecutionTime(CString Name)
	{
		return 0.0;
	}

	inline double GetExecutionTime()
	{
	/*	for (int ix = 0; ix < MaxIndex; ix++)
		{
			if (Name == Entries[ix].Name)
			{
				  return (double)(Entries[ix].endtime.QuadPart-Entries[ix].starttime.QuadPart)/(double)Frequency.QuadPart;
			}
		}
*/
		return (double)(oneTimeEnd.QuadPart-oneTimeStart.QuadPart)/(double)Frequency.QuadPart;

	}


	LARGE_INTEGER Frequency;
	Profiler();
	virtual ~Profiler();

	LARGE_INTEGER oneTimeStart,oneTimeEnd;

/*	struct Entry
	{
		LARGE_INTEGER starttime,endtime;
		CString Name;
	} Entries[MAXENTRY];*/

};


extern Profiler theProfiler;


#endif // !defined(AFX_PROFILER_H__ED8D57E8_94EF_4DE3_8893_81695E9176E9__INCLUDED_)
