// Sphere.cpp: implementation of the Sphere class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "simulator.h"
#include "Sphere.h"
#include <math.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Sphere::Sphere()
{
	m_Center.x = 0;
	m_Center.y = 0;
	m_Center.z = 0;
	m_Radius = 0;
	m_Radius2 = 0;
	m_AddIndex = 0;
	m_CurrMaxIndex = MAXADDVERTICES;
	m_AddVertices = new Point3[MAXADDVERTICES];

}

Sphere::~Sphere()
{
	delete m_AddVertices;

}

//////////////////////////////////////////////////////////////////////
// void enumStartAddVertices()
//
// This function starts the adding of vertices that can be used to form the
// sphere information
//
//////////////////////////////////////////////////////////////////////
void Sphere::enumStartAddVertices()
{
	m_AddIndex = 0;
	
}

//////////////////////////////////////////////////////////////////////
// void enumAddVertices()
//
// This function adds a vertices that can be used to form a sphere
//
//////////////////////////////////////////////////////////////////////
void Sphere::enumAddVertices(Point3 Vertices)
{
	m_AddVertices[m_AddIndex] = Vertices;
	int prev = m_AddIndex;	
	m_AddIndex++;

	if (m_AddIndex == m_CurrMaxIndex)
	{
		// k increase array size
		Point3 *tempo = new Point3[MAXADDVERTICES + m_CurrMaxIndex];
		memcpy(tempo,m_AddVertices,sizeof(Point3)*m_CurrMaxIndex);
		m_CurrMaxIndex = m_CurrMaxIndex + MAXADDVERTICES;
		delete []m_AddVertices;
		m_AddVertices = NULL;
		m_AddVertices = tempo;
		ASSERT(m_AddIndex >= 0 && m_AddIndex < 10000);
	}
}

//////////////////////////////////////////////////////////////////////
// void FormSphere()
//
// This function uses all of the vertices added and forms a sphere
//
// Algorithm
// Not the smartest but it should work
// 1) Take the centriod of all the vertices, this is the center point
// 2) Find the vertices furthest from the center point, this is the radius
//
// Notes
// A smarter algorithm can be developed by using an iterative routine to move the
// center closer to the furthest vertices to reduce the radius thus the
// area occupied
//
// 
//////////////////////////////////////////////////////////////////////
void Sphere::FormSphere()
{
	m_Center.x = 0;
	m_Center.y = 0;
	m_Center.z = 0;
	// 1) Take center
	for (int ix = 0; ix < m_AddIndex; ix++)
	{
		m_Center.x += m_AddVertices[ix].x;
		m_Center.y += m_AddVertices[ix].y;
		m_Center.z += m_AddVertices[ix].z;
		if (ix > 920)
			int df = 34;
	}

	m_Center.x = m_Center.x/m_AddIndex;
	m_Center.y = m_Center.y/m_AddIndex;
	m_Center.z = m_Center.z/m_AddIndex;

	m_Center.x = m_Center.y = m_Center.z = 0; // actually is should all be zero // so the object can 
									          //be rotates about its center
	

	// 2) find radius
	m_Radius = 0;
	for (ix = 0; ix < m_AddIndex; ix++)
	{
		double dx = m_Center.x - m_AddVertices[ix].x;
		double dy = m_Center.y - m_AddVertices[ix].y;
		double dz = m_Center.z - m_AddVertices[ix].z;
		double Delta = sqrt(dx*dx + dy*dy + dz*dz);
		if (Delta > m_Radius)
			m_Radius = Delta;
	}
	m_Radius2 = m_Radius*m_Radius;

}

//////////////////////////////////////////////////////////////////////
// bool RayInterect(Point3 Org, Point3 Dir, Point3 &IntPoint)
//
// This function checks if a ray has intersected the sphere
//
// Algorithm
//   From Real-Time rendering p571
// 
//////////////////////////////////////////////////////////////////////
bool Sphere::RayInterect(Point3 Org, Point3 Dir, Point3 &IntPoint)
{

	Point3 l = m_Center - Org;
	double s = Point3::Dot(l,Dir);
	double l2 = Point3::Dot(l,l);

	if (s < 0 && l2 > m_Radius2)
		return false;

	double m2 = l2 - s*s;
	if (m2 > m_Radius2)
		return false;

	// after this point we can return true if we don't care about the 
	// intersection point
	double q = sqrt(m_Radius2 - m2);

	double t;
	if (l2 > m_Radius2)
		t = s - q;
	else
		t = s+q;
	IntPoint = Org + Dir*t;

	return true;
}
