// Sphere.h: interface for the Sphere class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SPHERE_H__966E92FF_638F_4A46_B672_2E1CC11D0235__INCLUDED_)
#define AFX_SPHERE_H__966E92FF_638F_4A46_B672_2E1CC11D0235__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define MAXADDVERTICES 100

#include "stddef.h"

class Sphere  
{
public:
	bool RayInterect(Point3 Org, Point3 Dir, Point3 &IntPoint);

	// helper function to form the sphere 
	// basically all the vertices are entered and the class forms the sphere information
	void FormSphere();
	void enumAddVertices(Point3 Vertices);
	void enumStartAddVertices();

	inline double GetRadius() { return m_Radius;}
	inline double GetCenterX() { return m_Center.x;}
	inline double GetCenterY() { return m_Center.y;}
	inline double GetCenterZ() { return m_Center.z;}
	inline Point3 GetCenter() { return m_Center;}

	Sphere();
	virtual ~Sphere();

	// sphere coordinates
	Point3 m_Center;
	double m_Radius;
	double m_Radius2; // squared version of radius


private:


	// used to add vertices
	Point3 *m_AddVertices;
	int m_AddIndex;
	int m_CurrMaxIndex;

};

#endif // !defined(AFX_SPHERE_H__966E92FF_638F_4A46_B672_2E1CC11D0235__INCLUDED_)
