// VTManager.h: interface for the VTManager class.
//
// This class is the vertex and texture manager.  It manages sorting and 
// other intermediate processing for the normal style polygons.
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VTMANAGER_H__E55CC46D_E934_46BB_9D2D_F2C390406FB9__INCLUDED_)
#define AFX_VTMANAGER_H__E55CC46D_E934_46BB_9D2D_F2C390406FB9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "stddef.h"
#include <list>
#include "BaseObject.h"
#include <d3dx8.h>
#include "R3DWindow.h"

typedef std::list<BaseObject*> BaseObjectList;

#define MAXTEXTURES 200

class VTManager  
{
public:
	int currLightMapIndex;
	bool GetLightMapTexture(int height, int width, LPDIRECT3DTEXTURE8 &ppLightMap, int &textureID);
	void RenderObjects(LPDIRECT3DDEVICE8 g_pd3dDevice);

	void InitTextures(LPDIRECT3DDEVICE8 g_pd3dDevice);
	void InitLightMaps(LPDIRECT3DDEVICE8 g_pd3dDevice);
	void RenderList(TLNVERTEXSTRUCT *&pVertex, int &VertexCount);
	void AddTriangleList(int TextureNum, BaseObject &theObject);

	LPDIRECT3DTEXTURE8 m_pTextures[MAXTEXTURES];
	LPDIRECT3DVERTEXBUFFER8 g_BoxVB; // temp grid for debugging

	struct TextureList1
	{
		//BaseObjectList TriangleStip;
		BaseObjectList TriangleList;
	} TextureList[100]; // this should be a hash table mabey

	int TextureSwap[100]; // specifies when to swap

	struct LightMapList1
	{
		//BaseObjectList TriangleStip;
		LPDIRECT3DTEXTURE8 ppLightMap;
	} LightMapList[100]; // this should be a hash table mabey

	int lightMapArray[10000]; // stores indexes to the lightmap
	int lightMapIndex;

	inline int StartLightMapEnum() { lightMapIndex = 0;}
	inline int GetLightMapIndex()
	{
		int tempo = lightMapArray[lightMapIndex];
		lightMapIndex++;
		return tempo;
	}

	VTManager();
	virtual ~VTManager();

	LPDIRECT3DDEVICE8       g_pd3dDevice; // copy of rendering device


};

extern VTManager theVTManager; // global reference

#endif // !defined(AFX_VTMANAGER_H__E55CC46D_E934_46BB_9D2D_F2C390406FB9__INCLUDED_)
