#ifndef BINARYFORMAT
#define BINARYFORMAT

// the WRITE functions are from the DirectX exporter tool

#define GEOMETRY_KEY 0x0001
#define TEXTURE_NAME_KEY 0x0002
#define TEXTURE_INFO_KEY 0x0003
#define OPEN_BRACE_KEY 0x0004
#define CLOSE_BRACE_KEY 0x0005

#define TEXTVERSION 0.01
#define BINARYVERSION 0.02

#define WRITE_STRING(pbCur, pstring) {TCHAR* __pCurrDestChar = (TCHAR*)pbCur; TCHAR* __pCurrOrgChar = pstring;\
                                while(NULL != *__pCurrOrgChar) { *(__pCurrDestChar++) = *(__pCurrOrgChar++); }\
                                *(__pCurrDestChar++) = _T('\0'); pbCur = __pCurrDestChar;}\

#define READ_STRING(pbCur, pstring) {TCHAR* __pCurrOrgChar = (TCHAR*)pbCur; TCHAR* __pCurrDestChar = pstring;\
                                while(NULL != *__pCurrOrgChar) { *(__pCurrDestChar++) = *(__pCurrOrgChar++); }\
                                *(__pCurrDestChar++) = _T('\0'); pbCur = ++__pCurrOrgChar;}\

#define WRITE_WORD(pbCur, word) {WORD* __pword = (WORD*)pbCur; *(__pword++) = word;\
                             pbCur = (char *)__pword;}

#define READ_WORD(pbCur, word) {WORD* __pword = (WORD*)pbCur; word = *(__pword++);\
                             pbCur = (char *)__pword;}

#define WRITE_DWORD(pbCur, dword) {DWORD* __pdword = (DWORD*)pbCur; *(__pdword++) = dword;\
                             pbCur = (char *)__pdword;}

#define READ_DWORD(pbCur, dword) {DWORD* __pdword = (DWORD*)pbCur; dword = *(__pdword++);\
                             pbCur = (char *)__pdword;}

#define WRITE_FLOAT(pbCur, _float) {float* __pfloat = (float*)pbCur; *(__pfloat++) = _float;\
                             pbCur = (char *)__pfloat;}

#define READ_FLOAT(pbCur, _float) { float * __pfloat = (float*)pbCur; _float = *(__pfloat++);\
							pbCur = (char *)__pfloat;}


#endif