
#ifndef STDDEF_H
#define STDDEF_H

#include "math.h"
#include "Matrix.h"


#define PI 3.1415
#define SMALLE 0.0001 // small error e.g round off error

#define ABS(x) if (x < 0) x = -x;
// A structure for our custom vertex type
struct TEXTUREDVERTEXSTRUCT
{
    FLOAT x, y, z;      // The untransformed, 3D position for the vertex
    DWORD color;        // The vertex color
	FLOAT tu,tv;
};

// Our custom FVF, which describes our custom vertex structure
#define TEXTUREDVERTEX (D3DFVF_XYZ|D3DFVF_DIFFUSE |D3DFVF_TEX1 )

struct TLNVERTEXSTRUCT
{
    FLOAT x, y, z;      // The untransformed, 3D position for the vertex
	FLOAT nx, ny, nz;      // The untransformed, 3D position for the vertex
    DWORD color;        // The vertex color
	DWORD color2;        // The vertex color
	FLOAT tu,tv;
	FLOAT tu2,tv2;



};

// Our custom FVF, which describes our custom vertex structure
#define TLNVERTEX (D3DFVF_XYZ| D3DFVF_NORMAL |D3DFVF_TEX1 |D3DFVF_TEX2|D3DFVF_DIFFUSE |D3DFVF_SPECULAR ) //|D3DFVF_TEX0)



// A structure for our custom vertex type
struct CUSTOMVERTEX
{
    FLOAT x, y, z;      // The untransformed, 3D position for the vertex
    DWORD color;        // The vertex color
};

class Point3
{
	public:
	double x,y,z;
	Point3(double x, double y, double z)
	{
		this->x = x;
		this->y = y;
		this->z = z;
	}
	Point3()
	{}
	inline operator==(Point3 &RHS)
	{
		if (x == RHS.x)
			if (y == RHS.y)
				if (z = RHS.z)
					return true;
		return false;
	}

	inline Point3 operator-( const Point3 &RHS)
	{
		Point3 tReturn;
		tReturn.x = this->x - RHS.x;
		tReturn.y = this->y - RHS.y;
		tReturn.z = this->z - RHS.z;
		return tReturn;
	}

	inline Point3 operator-()
	{
		Point3 tReturn;
		tReturn.x = -this->x;
		tReturn.y = -this->y;
		tReturn.z = -this->z;
		return tReturn;
	}

	inline Point3 operator+( const Point3 &RHS)
	{
		Point3 tReturn;
		tReturn.x = this->x + RHS.x;
		tReturn.y = this->y + RHS.y;
		tReturn.z = this->z + RHS.z;
		return tReturn;
	}


	inline Point3 operator*( const Point3 &RHS)
	{
		Point3 tReturn;
		tReturn.x = this->x * RHS.x;
		tReturn.y = this->y * RHS.y;
		tReturn.z = this->z * RHS.z;
		return tReturn;
	}

	inline Point3 operator*( const double &RHS)
	{
		Point3 tReturn;
		tReturn.x  = this->x * RHS;
		tReturn.y  = this->y * RHS;
		tReturn.z  = this->z * RHS;
		return tReturn;
	}

	inline Point3 operator ^( const Point3 &RHS)
	{
		Point3 tReturn;
		tReturn.x  = this->y * RHS.z - this->z * RHS.y;
		tReturn.y  = this->z * RHS.x - this->x * RHS.z;
		tReturn.z  = this->x * RHS.y - this->y * RHS.x;
		return tReturn;
	}

	inline Point3 operator*(Matrix &RHS)
	{
		Point3 tReturn;
		tReturn.x = this->x * RHS._11 + this->y * RHS._21 + this->z * RHS._31 + RHS._41;
		tReturn.y = this->x * RHS._12 + this->y * RHS._22 + this->z * RHS._32 + RHS._42;
		tReturn.z = this->x * RHS._13 + this->y * RHS._23 + this->z * RHS._33 + RHS._43;
		return tReturn;
	}

	inline void Abs()
	{
		if (this->x < 0)
			this->x = -this->x;
		if (this->y < 0)
			this->y = -this->y;
		if (this->z < 0)
			this->z = -this->z;
	}

	inline void Normalize()
	{
		double t1,t2,t3;
		t1 = this->x;
		if (t1 < 0)
			t1 = -t1;
		t2 = this->y;
		if (t2 < 0)
			t2 = -t2;
		t3 = this->z;
		if (t3 < 0)
			t3 = -t3;
		
		double sum = t1 + t2+ t3;
		this->x = this->x / sum;
		this->z = this->z / sum;
		this->y = this->y / sum;
	}

	static inline double Dot(const Point3 &LHS, const Point3 &RHS)
	{
		return LHS.x*RHS.x + LHS.y*RHS.y + LHS.z*RHS.z;
	}

	static inline double Hypot(const Point3 &LHS, const Point3 &RHS)
	{
		return sqrt((LHS.x-RHS.x)*(LHS.x-RHS.x)
			+ (LHS.y-RHS.y)*(LHS.y-RHS.y)
			+ (LHS.z-RHS.z)*(LHS.z-RHS.z));
	}
	
	static inline double Hypot2(const Point3 &LHS, const Point3 &RHS)
	{
		return ((LHS.x-RHS.x)*(LHS.x-RHS.x)
			+ (LHS.y-RHS.y)*(LHS.y-RHS.y)
			+ (LHS.z-RHS.z)*(LHS.z-RHS.z));
	}	
};

// Our custom FVF, which describes our custom vertex structure
#define D3DFVF_CUSTOMVERTEX (D3DFVF_XYZ|D3DFVF_DIFFUSE)

// for line vertices
#define LINEVERTEX_TYPE  (D3DFVF_XYZ|D3DFVF_DIFFUSE)

struct LINEVERTEX
{
	float x,y,z; // Object space position for the vertex.
	DWORD color;
};

#define NORTH 0
#define EAST 1
#define SOUTH 2
#define WEST 3
#define UP 4
#define DOWN 5

class FCube
{
public:
	Point3 m_AMax;
	Point3 m_AMin;

	// slightly bigger values used for floating point round off errors
	Point3 m_AMaxEBigger;
	Point3 m_AMinEBigger;
			
	inline double Width() { return m_AMax.z-m_AMin.z;}
	inline double Height() { return m_AMax.y-m_AMin.y;}
	inline double Length() { return m_AMax.x-m_AMin.x;}

	inline AccountForE()
	{
		m_AMaxEBigger.x = m_AMax.x + SMALLE;
		m_AMaxEBigger.y = m_AMax.y + SMALLE;
		m_AMaxEBigger.z = m_AMax.z + SMALLE;

		m_AMinEBigger.x = m_AMin.x - SMALLE;
		m_AMinEBigger.y = m_AMin.y - SMALLE;
		m_AMinEBigger.z = m_AMin.z - SMALLE;
	}

	inline bool PointInCube(Point3 &Point)
	{
		if (Point.x <= m_AMax.x)
			if (Point.x >= m_AMin.x)
				if (Point.y <= m_AMax.y)
					if (Point.y >= m_AMin.y)
						if (Point.z <= m_AMax.z)
							if (Point.z >= m_AMin.z)
								return true;
		return false;
	}

	// uses the small error immune version of the cube
	inline bool PointInCubeWE(Point3 &Point)
	{
		if (Point.x <= m_AMaxEBigger.x)
			if (Point.x >= m_AMinEBigger.x)
				if (Point.y <= m_AMaxEBigger.y)
					if (Point.y >= m_AMinEBigger.y)
						if (Point.z <= m_AMaxEBigger.z)
							if (Point.z >= m_AMinEBigger.z)
								return true;
		return false;
	}

	inline void GetPlaneVertices(int Index, Point3 &v1, Point3 &v2, Point3 &v3)
	{
		// north
		if (NORTH == Index)
		{
			v1.x = m_AMax.x;
			v1.y = m_AMax.y;
			v1.z = m_AMax.z;

			v2.x = m_AMin.x;
			v2.y = m_AMax.y;
			v2.z = m_AMax.z;

			v3.x = m_AMin.x;
			v3.y = m_AMin.y;
			v3.z = m_AMax.z;
		}
		else if (EAST == Index)
		{
			//east
			v1.x = m_AMax.x;
			v1.y = m_AMax.y;
			v1.z = m_AMax.z;

			v2.x = m_AMax.x;
			v2.y = m_AMax.y;
			v2.z = m_AMin.z;

			v3.x = m_AMax.x;
			v3.y = m_AMin.y;
			v3.z = m_AMin.z;
		}
		else if (SOUTH == Index)
		{
			// south
			v1.x = m_AMax.x;
			v1.y = m_AMax.y;
			v1.z = m_AMin.z;

			v2.x = m_AMin.x;
			v2.y = m_AMax.y;
			v2.z = m_AMin.z;

			v3.x = m_AMin.x;
			v3.y = m_AMin.y;
			v3.z = m_AMin.z;
		}
		else if (WEST == Index)
		{
			// west
			v1.x = m_AMin.x;
			v1.y = m_AMax.y;
			v1.z = m_AMin.z;

			v2.x = m_AMin.x;
			v2.y = m_AMax.y;
			v2.z = m_AMax.z;

			v3.x = m_AMin.x;
			v3.y = m_AMin.y;
			v3.z = m_AMax.z;
		}
		else if (UP == Index)
		{
			// up
			v1.x = m_AMax.x;
			v1.y = m_AMax.y;
			v1.z = m_AMax.z;

			v2.x = m_AMin.x;
			v2.y = m_AMax.y;
			v2.z = m_AMax.z;

			v3.x = m_AMin.x;
			v3.y = m_AMax.y;
			v3.z = m_AMin.z;
		}
		else if (DOWN == Index)
		{
			// up
			v1.x = m_AMax.x;
			v1.y = m_AMin.y;
			v1.z = m_AMax.z;

			v2.x = m_AMin.x;
			v2.y = m_AMin.y;
			v2.z = m_AMax.z;

			v3.x = m_AMin.x;
			v3.y = m_AMin.y;
			v3.z = m_AMin.z;
		}
	}	
};



#endif