// ChildView.cpp : implementation of the CChildView class
//

#include "stdafx.h"
#include "MapEditor.h"
#include "ChildView.h"
#include "PlaneObject.h"
#include "htmlhelp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CChildView *theViewPtr;

/////////////////////////////////////////////////////////////////////////////
// CChildView

CChildView::CChildView()
{
	ResetOptions();

    Popup.LoadMenu(IDR_POPUP1); 

	::QueryPerformanceFrequency(&EditView.Frequency);
	::QueryPerformanceCounter(&EditView.StartDrawTime);
	::QueryPerformanceCounter(&EditView.EndDrawTime);

	EditView.ScrollViewPtr = NULL;
	EditView.StatsPercent = -1;
	
D3DXVECTOR3 v1,v2,v3,v4;


//	PlaneObject *NewPlane;

/*	v1.x = 0.0f;
	v1.y = 0;
	v1.z = 0.0f;

	v2.x = 4.0f;
	v2.y = 4.0f;
	v2.z = 0.0f;

	v3.x = 4.0f;
	v3.y = 4.0f;
	v3.z = 4.0f;

	v4.x = 0.0f;
	v4.y = .0f;
	v4.z = 4.0f;



	NewPlane = new PlaneObject(PLANE(v1,v2,v3,v4),0xff0000ff);

	v1.x = 0.0f;
	v1.y = 0;
	v1.z = 0.0f;

	v2.x = 4.0f;
	v2.y = 0.0f;
	v2.z = 0.0f;

	v3.x = 4.0f;
	v3.y = 0.0f;
	v3.z = 4.0f;

	v4.x = 0.0f;
	v4.y = .0f;
	v4.z = 4.0f;

	NewPlane = new PlaneObject(PLANE(v1,v2,v3,v4),0xff00ff00);

	v1.x = 2.1f;
	v1.y = 2.1f;
	v1.z = 2.1f;

	v2.x = 2.9f;
	v2.y = 2.1f;
	v2.z = 2.1f;

	v3.x = 2.9f;
	v3.y = 2.1f;
	v3.z = 2.9f;

	v4.x = 2.1f;
	v4.y = 2.1f;
	v4.z = 2.9f;

	NewPlane = new PlaneObject(PLANE(v1,v2,v3,v4),0xff234334);*/
}

CChildView::~CChildView()
{
	
}


BEGIN_MESSAGE_MAP(CChildView,CWnd )
	//{{AFX_MSG_MAP(CChildView)
	ON_WM_PAINT()
	ON_COMMAND(ID_CAMERASETTINGS_RESETVIEW, OnCamerasettingsResetview)
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	ON_WM_CREATE()
	ON_COMMAND(ID_OPTIONS_OCTGRIDOPTIONS, OnOptionsOctgridoptions)
	ON_COMMAND(ID_OCTTREE_NEWOCTTREE, OnOcttreeNewocttree)
	ON_COMMAND(ID_EDIT_GROUP, OnEditGroup)
	ON_COMMAND(ID_EDIT_UNGROUP, OnEditUngroup)
	ON_WM_CONTEXTMENU()
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_WM_MBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_MBUTTONDOWN()
	ON_COMMAND(ID_TOGGLE4VIEW, OnToggle4view)
	ON_WM_HELPINFO()
	ON_COMMAND(ID_TERRAINOPTIONS_GENERATENEWTERRAIN, OnTerrainoptionsGeneratenewterrain)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChildView message handlers

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL);

	return TRUE;
}

 void CChildView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

    // to time the rendering
    LARGE_INTEGER frequency,starttime,endtime;    
    ::QueryPerformanceFrequency(&frequency);
    ::QueryPerformanceCounter(&starttime);
	SSDT(starttime);

	// render the directX stuff
	TheViewManager.OnRender();
    
	// check how long it took
    ::QueryPerformanceCounter(&endtime);
    EditView.RenderingTime = (float)(endtime.QuadPart-starttime.QuadPart)/(float)frequency.QuadPart;

	// paint the stats area
	PaintStatsArea(dc);

		// to time the rendering, mostly for debug value
    ::QueryPerformanceCounter(&endtime);
	SEDT(endtime);

}


BOOL CChildView::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	// TODO: Add your specialized code here and/or call the base class


	//TheViewManager.OctTreePtr = &theOctTree;

	
	return CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);
}


void CChildView::OnCamerasettingsResetview() 
{
	TheViewManager.RCResetView();
	ResetOptions();
	InvalidateRect(&EditView.StatsArea,false);
	
}

void CChildView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	
	CWnd ::OnKeyDown(nChar, nRepCnt, nFlags);

	InvalidateRect(&EditView.StatsArea,false);
}

void CChildView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	
	CWnd ::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CChildView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	TheViewManager.OnLButtonDown(nFlags,point);
	InvalidateRect(&EditView.StatsArea,false);

	CWnd ::OnLButtonDown(nFlags, point);
}

void CChildView::ResetOptions()
{
	Options.E_ZoomEnabled = true;
	Options.CurrCursor = 0;

}

void CChildView::OnMouseMove(UINT nFlags, CPoint point) 
{
	TheViewManager.OnMouseMove(nFlags,point);
	InvalidateRect(&EditView.StatsArea,false);

	CWnd ::OnMouseMove(nFlags, point);
}

int CChildView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd ::OnCreate(lpCreateStruct) == -1)
		return -1;

	CRect WindowSize;
	this->GetWindowRect(&WindowSize);

	TheViewManager.FrameWindow.ViewWindowPtr = this;
	CWnd *tempo = FramePtr;
	TheViewManager.FramePtr = FramePtr;
    TheViewManager.Create();  
	TheViewManager.SetGridDepth(1);

	WindowSize.left = 800;
	WindowSize.right = 1024;
	WindowSize.top = 0;
	WindowSize.bottom = 662;

	EditView.StatsArea.top = 0;
	EditView.StatsArea.bottom = 150;
	EditView.StatsArea.left = 800;
	EditView.StatsArea.right = 1024;

	EditView.EditArea.top = 151;
	EditView.EditArea.bottom = 662;
	EditView.EditArea.left = 800;
	EditView.EditArea.right = 1020;

	theViewPtr = this;



	//EditView.ScrollEditView.Create(EditView.EditArea,this);
	
	return 0;
}

void CChildView::OnOptionsOctgridoptions() 
{
	OctGridOptions tDialog;

	tDialog.m_GridDepth = TheViewManager.GridDepth;

	if (tDialog.DoModal() == IDOK)
	{
		TheViewManager.SetGridDepth(tDialog.m_GridDepth);
	}
	
}

void CChildView::OnOcttreeNewocttree() 
{
	NewOctTree tDialog;

	if (tDialog.DoModal() == IDOK)
	{
		// replicate the height array first
		float HeightArray[32];
		HeightArray[0] = 0; // always
		for (int ix = 1; ix <= tDialog.m_SY; ix++)
		{
			HeightArray[ix] = (float)ix*(float)tDialog.m_DY/tDialog.m_SY;
		}

		theOctTree.CreateOctTree(tDialog.m_DZ,tDialog.m_DX,HeightArray,tDialog.m_SZ,tDialog.m_SX,tDialog.m_SY);
	}	
}

void CChildView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	TheViewManager.OnLButtonUp(nFlags,point);

	InvalidateRect(&EditView.StatsArea,false);
	UpdateWindow();

	
	CWnd ::OnLButtonUp(nFlags, point);
}

void CChildView::OnEditGroup() 
{
	theOctTree.SelectCreateGroup();
	
}

void CChildView::OnEditUngroup() 
{
	theOctTree.SelectDeleteGroup();
	
}

void CChildView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	 // make sure window is active
   GetParentFrame()->ActivateFrame();

   CPoint local = point;
   ScreenToClient(&local);

   UpdateWindow();

  CMenu* pPopup = Popup.GetSubMenu(0);
  ASSERT(pPopup != NULL);

  pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
     point.x, point.y,
  AfxGetMainWnd()); // use main window for cmds

	
}



void CChildView::OnMButtonUp(UINT nFlags, CPoint point) 
{
	TheViewManager.OnMButtonUp(nFlags,point);
	
	CWnd ::OnMButtonUp(nFlags, point);
}

void CChildView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	TheViewManager.OnRButtonDown(nFlags,point);
	
	CWnd ::OnRButtonDown(nFlags, point);
}

void CChildView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	TheViewManager.OnRButtonUp(nFlags,point);
	
	CWnd ::OnRButtonUp(nFlags, point);
}

void CChildView::OnMButtonDown(UINT nFlags, CPoint point) 
{
	TheViewManager.OnMButtonDown(nFlags,point);
	
	CWnd ::OnMButtonDown(nFlags, point);
}

void CChildView::OnToggle4view() 
{
	TheViewManager.OnToggle4View();
	InvalidateRect(&EditView.StatsArea,false);
	
}

BOOL CChildView::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	CFile FileExists;

    if (FileExists.Open("..\\PCMapEditor.chm",CFile::modeReadWrite | CFile::shareDenyNone))
    {
        FileExists.Close();
        if (HtmlHelp(this->m_hWnd,"..\\PCMapEditor.chm",HH_DISPLAY_TOPIC,NULL) == NULL)
        {
            AfxMessageBox("Warning, Could not open help file");
        }
    }
    else if (FileExists.Open(".\\PCMapEditor.chm",CFile::modeReadWrite | CFile::shareDenyNone))
    {
        FileExists.Close();
        if (HtmlHelp(this->m_hWnd,".\\PCMapEditor.chm",HH_DISPLAY_TOPIC,NULL) == NULL)
        {
            AfxMessageBox("Warning, Could not open help file");
        }
    }
    else if (FileExists.Open(".\\hlp\\PCMapEditor.chm",CFile::modeReadWrite | CFile::shareDenyNone))
    {
        FileExists.Close();
        if (HtmlHelp(this->m_hWnd,".\\hlp\\PCMapEditor.chm",HH_DISPLAY_TOPIC,NULL) == NULL)
        {
            AfxMessageBox("Warning, Could not open help file");
        }
    }
    else if (FileExists.Open("..\\hlp\\PCMapEditor.chm",CFile::modeReadWrite | CFile::shareDenyNone))
    {
        FileExists.Close();
        if (HtmlHelp(this->m_hWnd,"..\\hlp\\PCMapEditor.chm",HH_DISPLAY_TOPIC,NULL) == NULL)
        {
            AfxMessageBox("Warning, Could not open help file");
        }
    }
    else
        AfxMessageBox("Warning, Could not open help file");
	
	return CWnd ::OnHelpInfo(pHelpInfo);
}

void CChildView::OnTerrainoptionsGeneratenewterrain() 
{
	TerrainOptions TerrainOptionsDlg;
	OctTree::OctTreeInfo Info = theOctTree.GetOctTreeInfo();
	TerrainOptionsDlg.SetMaxHeight(Info.Height);

	if (TerrainOptionsDlg.DoModal() == IDOK)
	{
		theTerrainManager.GenerateTerrain(TerrainOptionsDlg.m_NumXSegments,
			TerrainOptionsDlg.m_NumZSegments,TerrainOptionsDlg.m_Height);
	}
	
}


//=====================================================================
// PaintStatsArea(CDC &dc)
// 
// Usage: During the main drawing loop it draws in the stats area
//
//=====================================================================
void CChildView::PaintStatsArea(CDC &dc)
{
	// form the double buffer for the stats area
	CDC DBufferDC;
    DBufferDC.CreateCompatibleDC(&dc);
    CBitmap DBufferBitmap;
	DBufferBitmap.CreateCompatibleBitmap(&dc,EditView.StatsArea.Width(),EditView.StatsArea.Height());
	CBitmap *pOldBitmap = DBufferDC.SelectObject(&DBufferBitmap);

	CRect StatsSize = CRect(0,0,EditView.StatsArea.Width(),EditView.StatsArea.Height());	

	// give the stats area a blue background
	CBrush Brush(RGB(215,255,255));
	DBufferDC.SetBkColor(RGB(215,255,255));
    DBufferDC.FillRect(&StatsSize,&Brush);

	// perform any drawing here

	char tempo[50];
    sprintf(tempo,"Rendering Time: %f",EditView.RenderingTime);
    DBufferDC.TextOut(10,10,tempo);

	sprintf(tempo,"Total Time: %f",EditView.DrawTime);
    DBufferDC.TextOut(10,25,tempo);

	if (EditView.StatsPercent != -1)
	{
		sprintf(tempo,"Current Operation Percent %d%",EditView.StatsPercent);
		DBufferDC.TextOut(10,40,tempo);
	}


	// copy the double buffer to the main area
    dc.BitBlt(EditView.StatsArea.left,EditView.StatsArea.top,EditView.StatsArea.Width(),EditView.StatsArea.Height(),&DBufferDC,0,0,SRCCOPY);
    DBufferDC.SelectObject(pOldBitmap);

}

CChildView *GetViewPtr(void)
{
	return theViewPtr;
};

// returns the edit view offset for making an edit view
CRect CChildView::GetEditViewWindow()
{
	return EditView.EditArea;
}

// called by anyone to redraw everything
void CChildView::Redraw()
{
	InvalidateRect(&EditView.StatsArea,false);
	UpdateWindow();
}

void CChildView::SetStatsPercent(int Percent)
{
	EditView.StatsPercent = Percent;
	InvalidateRect(&EditView.StatsArea,false);
	UpdateWindow();
	if (Percent == 100)			
		EditView.StatsPercent = -1; // so it doesn't draw again

}
