// MDirectX.h: interface for the MDirectX class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MDIRECTX_H__F2D5BCC1_A443_4E2F_9216_D0C242BB33CE__INCLUDED_)
#define AFX_MDIRECTX_H__F2D5BCC1_A443_4E2F_9216_D0C242BB33CE__INCLUDED_

#include "OctTree.h"	// Added by ClassView
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// DirectX includes
#include <D3D8.h>
#include "D3DApp.h"
#include "D3DUtil.h"
#include "D3DFile.h"
#include "DXUtil.h"
#include "D3DRes.h"

#include "UMath.h"

#include "DirectXWnd.h"

#define ZOOMPIXELPERCENT .01 // a one pixel movement is a 5% zoom in.

class MDirectX //:public CD3DApplication  
{
public:

	int GridDepth;

	void RCResetView();

	
	UMath Math;
	void AdjustCameraPosition(float &dx, float &dy, float &dz, float AngleX, float AngleY, float Radius);
	void AdjustCameraPosition1(float &dx, float &dy, float &dz, float AngleX, float AngleY, float Radius);
	void AdjustCameraPosition();
	HRESULT Render();
	void OnRender();

	LPDIRECT3DDEVICE8 m_pd3dDevice; 
	D3DSURFACE_DESC m_d3dsdBackBuffer;

	CRect WindowSize; // placement and size of the display window
	CWnd *LParent;
	CWnd *FramePtr; // ptr to the frame window, used for initialization

	void Create(); // initialization called by parent window

	struct CAMERA
    {
        D3DXVECTOR3 Eye; // the current position of the camera
        D3DXVECTOR3 At; // the point at which to look at
        D3DXVECTOR3 Orientation;

		BOOL MoveUp;
        BOOL MoveLeft;
        BOOL MoveRight;
        BOOL MoveDown;

		// memory for user input
		int PanX,PanY; // used to pan the mouse from user input
		int ZoomIn;
		float XAngle,YAngle;
		CPoint PrevMousePoint; // current point of zoom movement
        float ZoomRatio;    

		// Storage if anyone wants to see them
	    D3DXMATRIX matrixView;
		D3DXMATRIX matrixProj;
		 
	};

	CAMERA TheCamera;

	// user interface functionality, recieves input from view window that is
	// routed to the directX camera control
	void RCSelectObject(CPoint Point, BOOL AddtoGroup);
	void RCZoom(CPoint Point);
	void RCSetZoomPoint(CPoint Point);
	void OnMouseMove(UINT nFlags, CPoint Point);

	LPDIRECT3DVERTEXBUFFER8 g_pGridVB; // Buffer to hold vertices


	// constructers destructers
	MDirectX();
	virtual ~MDirectX();

};

#endif // !defined(AFX_MDIRECTX_H__F2D5BCC1_A443_4E2F_9216_D0C242BB33CE__INCLUDED_)
