// OctTree.h: interface for the OctTree class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OCTTREE_H__DA6C940D_82A6_49CA_BE3D_AAEF0CDC609F__INCLUDED_)
#define AFX_OCTTREE_H__DA6C940D_82A6_49CA_BE3D_AAEF0CDC609F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "UMath.h"
#include <stack> 
#include <vector>
#include <list>

// standard includes
#include <D3D8.h>
#include "D3DApp.h"
#include "D3DUtil.h"
#include "D3DFile.h"
#include "DXUtil.h"
#include "D3DRes.h"
#include "StdObject.h"
#include "GroupStruct.h"


class StdObject;
class GroupStruct;
class TileObject;


typedef class StdObject *StdObjectPtr;
 
typedef std::list<StdObject*> OBJECTLIST;
//typedef std::list<TileObject*> TILELIST;
typedef std::list<GroupStruct*> GROUPLIST;

class OctNode;

typedef class OctNode *OctNodePtr;

class OctNode
{
public:
	FCube Area; // the area of the node
	OctNodePtr Parent;
	OctNodePtr Children[8]; // up to 8 children
	// index X Y Z using RHS
	// 0     + + -
	// 1     - + -
	// 2	 - + +
	// 3     + + +
	// 4     + - -
	// 5     - - -
	// 6	 - - +
	// 7     + - +
	OctNodePtr Neighbours[6]; // up to 6 Neighbours
	// index position
	// 0	 +Z
	// 1     +X
	// 2     -Z
	// 3	 -X
	// 4     +Y
	// 5     -Y

	// some object list here
	int Flag; // traversal flag
//	int ObjectListPtr; // right now just an int used in construction

	OBJECTLIST ObjectList; // the objectlist
	//OBJECTLIST TileList; // the objectlist

	OctNode();
};

class OctTree  
{
	// a stack is used to construct the oct tree
	struct ConstructOct
	{
		OctNodePtr NodePtr;
		int WidthSplitsLeft;
		int HeightSplitsLeft;
		int LengthSplitsLeft;
	};

	std::stack<ConstructOct, std::vector<ConstructOct> > ConstructStack;


public:
	GROUPLIST SelectList;

	OctTree();
	virtual ~OctTree();

	int UGetChildIndex(FCube &Cube, D3DVECTOR &Point, OctNodePtr &CurrNode);

		// create
	void CreateOctTree(float Width, float Length, float HeightArray[], int WidthSegments,
								int LengthSegments, int HeightSegments);

	void RenderOctGrid(LINEVERTEX *&pVertex, int &VertexCount, int DepthLevel);

	struct OctTreeInfo
	{
		float Width;
		float Length;
		float Height;
		int WidthSegments;
		int LengthSegments;
		int HeightSegments;
	};

	

private:


	void CreateOctTree1();
	
	D3DVECTOR CreateOctTreeGPoint(FCube &CurrBounds, int &DesiredN);

	// grid rendering functionality
	void RenderFormFace(LINEVERTEX *&pVertex, const D3DVECTOR Points[4], int &VertexCount, const DWORD &Color);
	void RenderFormCube(LINEVERTEX *&pVertex,const FCube &theCube, int &VertexCount, const DWORD &Color);

	
	void CreateOctTreeCN(OctNodePtr &CurrentNode, int &CurrLevel);

	// delete
	void DeleteOctTree();
	
	OctTreeInfo OctreeInfo; // basic info of the octree
	OctNodePtr HeadOctPtr; // the head oct tree ptr;

public:
	void ClearOctTree();
	void RemoveObjectfromNode(StdObject *theObject, OctNode *OctNodePtr);
	void SelectDeleteGroup();
	void SelectCreateGroup();
	void _Destruct();
	void SelectObject(const RAY &ray, BOOL AddtoGroup);
	PLANE UGetPlane(OctNodePtr tOctNodePtr, int neighbour);
	void RenderAllObjects(LPDIRECT3DDEVICE8 m_pd3dDevice);
	int AddIterator;
	void AddObjecttoNode(StdObjectPtr theObject, OctNodePtr theNode);
	void AddStartSequence();

	inline OctNodePtr GetHeadOctNode() { return HeadOctPtr;}
	inline OctTreeInfo GetOctTreeInfo() { return OctreeInfo;}


};

extern OctTree theOctTree; // global reference

#endif // !defined(AFX_OCTTREE_H__DA6C940D_82A6_49CA_BE3D_AAEF0CDC609F__INCLUDED_)
