// PlaneObject.cpp: implementation of the PlaneObject class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MapEditor.h"
#include "PlaneObject.h"
#include "OctTree.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

// Note, should not be used, doesn't do anything
PlaneObject::PlaneObject()
{
	g_pPlaneVB = NULL;

}

// This is the constructer that should be used
PlaneObject::PlaneObject(PLANE Plane, DWORD Color)
{
	g_pPlaneVB = NULL; // null the vertex buffer for this one for rendering purposes

	this->Plane = Plane; // give it the plane data
	this->Color = Color;
	AddGenerateBoundingSphere(); // generate bounding sphere data
//	UAddPlanetoOctree(Plane);
	AddObjectToOcttree();
}

PlaneObject::~PlaneObject()
{
	if (g_pPlaneVB != NULL)
		g_pPlaneVB->Release();

/*	// delete any reference of this object in the 
	OCTLIST::iterator curr = OctList.begin();
	OCTLIST::iterator end = OctList.end();
	while (curr != end)
	{
		// remove object from list
		(*curr)->ObjectList.remove(this);		
		curr++;
	}
*/
	delete GroupPtr;


}

//---------------------------------------------------------------------
// AddObjectToOcttree()
// 
// Usage: Internal on creating the object
// 
// Algorithm
// 1) Check if all four verteces are in the root node of the octree if not exit
// 2) Get the leaf node for one of the verteces
// 3) Do a simple check if the remaining verteces are in the current node
//    if it is form the list and then goto 
// 4) Do a simple check if the remaining verteces are contained in the current nodes neighbours
//    if it is form the list and then goto
// 5) Do the plane to plane intersection test on the current nodes neighbours, and adding
//    each node along the way to the list
// 6) Call a function which adds the contents of the list into the octree
//
// returns true if object created successfully
//---------------------------------------------------------------------
BOOL PlaneObject::AddObjectToOcttree()
{
	OctNodePtr tOctNodePtr = theOctTree.GetHeadOctNode();
	OctNodePtr tHeadOctNodePtr = tOctNodePtr;

	OctList;
	BOOL GotAllOct;

	ASSERT(tOctNodePtr != NULL); // should never happen

	// 1) Check if plane is valid
	if (!tOctNodePtr->Area.PointinCube(Plane.v1))
		return false;
	if (!tOctNodePtr->Area.PointinCube(Plane.v2))
		return false;;
	if (!tOctNodePtr->Area.PointinCube(Plane.v3))
		return false;;
	if (!tOctNodePtr->Area.PointinCube(Plane.v4))
		return false;;

	// 2) search for the leaf octnode of V1 of plane
	while (tOctNodePtr->Children[0] != NULL)
	{
		int newIndex = theOctTree.UGetChildIndex(tOctNodePtr->Area,Plane.v1,tOctNodePtr);

		tOctNodePtr = tOctNodePtr->Children[newIndex];
	}

	// 3) O.K now check if all of the other verteces are there
	GotAllOct = false;

	if (tOctNodePtr->Area.PointinCube(Plane.v2))
		if (tOctNodePtr->Area.PointinCube(Plane.v3))
			if (tOctNodePtr->Area.PointinCube(Plane.v4))
			{
				// add object just to this cube
				OctList.push_back(tOctNodePtr);
				GotAllOct = true;
			}

	// 4) check if perhaps verteces are in its neighbours
	OctNodePtr t1,t2,t3; // temp node pointers for neighbour storage
	t1 = t2 = t3 = NULL;	
	if (!GotAllOct)
	{
		GotAllOct = true;; // not in the neighbours
		// check out v2;
		if (tOctNodePtr->Area.PointinCube(Plane.v2))
		{
			// don't want to continue looking if in the current node
		}
		else
		{
			for (int ix = 0; ix < 6; ix++)
			{
				if (tOctNodePtr->Neighbours[ix] != NULL)
				{
					if (tOctNodePtr->Neighbours[ix]->Area.PointinCube(Plane.v2))
					{
						// garbage code, in case the nieghbours hold all of the values,
						// the neighbours have to be put into variables for futures use, which 
						// is done below.
						if ((tOctNodePtr->Neighbours[ix] != t1) &&
							(tOctNodePtr->Neighbours[ix] != t2) &&
							(tOctNodePtr->Neighbours[ix] != t3))
						{									
							t1 = tOctNodePtr->Neighbours[ix];						
							
						}
						break;
					}
				}
			}
			if (ix == 6)
			{
				GotAllOct = false;		
			}
		}
		if (GotAllOct)
		{
			// check out v3;
			if (tOctNodePtr->Area.PointinCube(Plane.v3))
			{
				// don't want to continue looking if in the current node
			}
			else
			{
				for (int ix = 0; ix < 6; ix++)
				{
					if (tOctNodePtr->Neighbours[ix] != NULL)
					{
						if (tOctNodePtr->Neighbours[ix]->Area.PointinCube(Plane.v3))
						{
							// garbage code, in case the nieghbours hold all of the values,
							// the neighbours have to be put into variables for futures use, which 
							// is done below.
							if ((tOctNodePtr->Neighbours[ix] != t1) &&
								(tOctNodePtr->Neighbours[ix] != t2) &&
								(tOctNodePtr->Neighbours[ix] != t3))
							{
								if (t1 == NULL)						
									t1 = tOctNodePtr->Neighbours[ix];						
								else 						
									t2 = tOctNodePtr->Neighbours[ix];
							}
							break;
						}
					}
				}
				if (ix == 6)
				{
					GotAllOct = false;			
				}
			}
		}
		if (GotAllOct)
		{
			// check out v4;
			if (tOctNodePtr->Area.PointinCube(Plane.v4))
			{	
				// don't want to continue looking if in the current node
			}
			else
			{
				for (int ix = 0; ix < 6; ix++)
				{
					if (tOctNodePtr->Neighbours[ix] != NULL)
					{
						if (tOctNodePtr->Neighbours[ix]->Area.PointinCube(Plane.v4))
						{
							// garbage code, in case the nieghbours hold all of the values,
							// the neighbours have to be put into variables for futures use, which 
							// is done below.
							if ((tOctNodePtr->Neighbours[ix] != t1) &&
								(tOctNodePtr->Neighbours[ix] != t2) &&
								(tOctNodePtr->Neighbours[ix] != t3))
							{
								if (t1 == NULL)						
									t1 = tOctNodePtr->Neighbours[ix];						
								else if (t2 == NULL)						
									t2 = tOctNodePtr->Neighbours[ix];						
								else
									t3 = tOctNodePtr->Neighbours[ix];
							}
							break;
						}
					}
				}
				if (ix == 6)
				{
					GotAllOct = false;				
				}
			}
		}
		// O.K so it is contained in the nieghbours.  Then add the nieghbours into the list
		if (GotAllOct)
		{
				OctList.push_back(tOctNodePtr);
				if (t1 != NULL)				
					OctList.push_back(t1);				
				if (t2 != NULL)
					OctList.push_back(t2);
				if (t3 != NULL)
					OctList.push_back(t3);
		}
	}
	// 5) Do an plane to plane intersection test on the neighbours to find the intersection points
	if (!GotAllOct)
	{
		OCTNODELIST OctNodeList;
		OctNodeList.push(tOctNodePtr);
		int InteratorFlag = tHeadOctNodePtr->Flag + 1; // get the iterator int.
		tOctNodePtr->Flag = InteratorFlag; // flag this node so it isn't visited again

		while (!OctNodeList.empty())
		{			 
			tOctNodePtr = OctNodeList.top();
			OctNodeList.pop(); // pop it out here
			// add into node list here
			OctList.push_back(tOctNodePtr);

			// check each neighbour and add into stack as we go along
			for (int ix = 0; ix < 6; ix++)
			{
				if (tOctNodePtr->Neighbours[ix] != NULL)
				{
					if (tOctNodePtr->Neighbours[ix]->Flag != InteratorFlag)
					{
						// do collision test here
						PLANE TestPlane;
						TestPlane = theOctTree.UGetPlane(tOctNodePtr,ix);
						if (Math.IntersectPlane(Plane,TestPlane))
						{
							OctNodeList.push(tOctNodePtr->Neighbours[ix]); // add it to the stack if it intersects the plane
							tOctNodePtr->Neighbours[ix]->Flag = InteratorFlag; // flag it so it isn't visited again
						}
						
					}
				}
			}
		}
		tHeadOctNodePtr->Flag = InteratorFlag;
	}

	// 6) Got the list, add the list to the octree
	
	theOctTree.AddStartSequence();
	OCTLIST::iterator curr = OctList.begin();
	OCTLIST::iterator end = OctList.end();
	while (curr != end)
	{
		// add the object to the octnode
		theOctTree.AddObjecttoNode(this,*curr);		
		curr++;
	}

	return true;

}

//---------------------------------------------------------------------
// Render(LPDIRECT3DDEVICE8 m_pd3dDevice)
// 
// Usage: To render the plane
//---------------------------------------------------------------------
void PlaneObject::Render(LPDIRECT3DDEVICE8 m_pd3dDevice)
{
	if (g_pPlaneVB == NULL)
	{
		// The Vertex buffer is created on the first render call
		if( FAILED( m_pd3dDevice->CreateVertexBuffer( 8*sizeof(VERTEX),
												   D3DUSAGE_DYNAMIC ,
												   VERTEX_TYPE,
												   D3DPOOL_DEFAULT,
												   &g_pPlaneVB 
												   ) )) 
                                                   AfxMessageBox("Failed plane Vertex Buffer");
		// now form the vertex that doesn't change
		VERTEX* pVertex; // pointer for traversal of VB
		if( SUCCEEDED( g_pPlaneVB->Lock(0, 0, (BYTE**)&pVertex, 0 ) ) )
		{
			pVertex[0].position = Plane.v1;
			pVertex[0].color = Color;
			pVertex[0].tu = 0.0f;
			pVertex[0].tv = 0.0f;

			pVertex[1].position = Plane.v2;
			pVertex[1].color = Color;
			pVertex[1].tu = 1.0f;
			pVertex[1].tv = 1.0f;

			pVertex[2].position = Plane.v4;
			pVertex[2].color = Color;
			pVertex[2].tu = 0.0f;
			pVertex[2].tv = 1.0f;

			pVertex[3].position = Plane.v3;
			pVertex[3].color = Color;
			pVertex[3].tu = 0.0f;
			pVertex[3].tv = 0.0f;

			g_pPlaneVB->Unlock();
		}
	}
				
	m_pd3dDevice->SetTexture(0,NULL);
			
	//m_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_WIREFRAME);
	m_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_SOLID);
	m_pd3dDevice->SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE); // no culling
   
	m_pd3dDevice->SetStreamSource( 0, g_pPlaneVB, sizeof(VERTEX) );
	m_pd3dDevice->SetVertexShader( VERTEX_TYPE ); 			 

	m_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2);

}

//---------------------------------------------------------------------
// BOOL IntersectBoundingSphere(const Ray &Line)
// 
// Usage: First collision detection test, between a sphere and a line
//
// Algorithm, solves the equation of a sphere and a parameterized line
//
//---------------------------------------------------------------------
BOOL PlaneObject::IntersectBoundingSphere(const RAY &Ray, D3DXVECTOR3 &IntersectionPoint)
{
	double ax,bx,cx,
		  ay,by,cy,
		  az,bz,cz;

	D3DXVECTOR3 tReturn,ttReturn;

	LINE Line(Ray);	// we need a line not a ray	

	// We are solving for the parameterized t, to do this generate quadratic equation for it
	ax = (Line.Point1.x - Line.Point2.x)*(Line.Point1.x - Line.Point2.x);
	bx = 2*(Line.Point1.x - Line.Point2.x)*(Line.Point2.x - BoundingSphere.Center.x);
	cx = (Line.Point2.x - BoundingSphere.Center.x)*(Line.Point2.x - BoundingSphere.Center.x);

	ay = (Line.Point1.y - Line.Point2.y)*(Line.Point1.y - Line.Point2.y);
	by = 2*(Line.Point1.y - Line.Point2.y)*(Line.Point2.y - BoundingSphere.Center.y);
	cy = (Line.Point2.y - BoundingSphere.Center.y)*(Line.Point2.y - BoundingSphere.Center.y);

	az = (Line.Point1.z - Line.Point2.z)*(Line.Point1.z - Line.Point2.z);
	bz = 2*(Line.Point1.z - Line.Point2.z)*(Line.Point2.z - BoundingSphere.Center.z);
	cz = (Line.Point2.z - BoundingSphere.Center.z)*(Line.Point2.z - BoundingSphere.Center.z);

	double A,B,C;

	A = ax+ay+az;
	B = bx+by+bz;
	C = cx+cy+cz - BoundingSphere.Radius*BoundingSphere.Radius;

	// now solve quadratic formula
	double temp1 = B*B - 4*A*C;

	if (temp1 < 0)
		return false;

	// Now solve for the point
	float T1 = (-B + sqrt(temp1))/(2*A);
	if (T1 >= 0 && T1 <= 1)
	{
		tReturn.x = Line.Point1.x*T1 + Line.Point2.x*(1-T1);
		tReturn.y = Line.Point1.y*T1 + Line.Point2.y*(1-T1);
		tReturn.z = Line.Point1.z*T1 + Line.Point2.z*(1-T1);
		T1 = (-B - sqrt(temp1))/(2*A);
		if (T1 >= 0 && T1 <= 1)
		{
			// O.K now we have to figure out which point is closer
			ttReturn.x = Line.Point1.x*T1 + Line.Point2.x*(1-T1);
			ttReturn.y = Line.Point1.y*T1 + Line.Point2.y*(1-T1);
			ttReturn.z = Line.Point1.z*T1 + Line.Point2.z*(1-T1);
			float D1,D2;
			D1 = Math.GetDistance(Line.Point1,tReturn);
			D2 = Math.GetDistance(Line.Point1,ttReturn);

			if (D1 > D2)
				tReturn = ttReturn;
		}
		return true;
	}	

	T1 = (-B - sqrt(temp1))/(2*A);
	if (T1 >= 0 && T1 <= 1)
	{
		tReturn.x = Line.Point1.x*T1 + Line.Point2.x*(1-T1);
		tReturn.y = Line.Point1.y*T1 + Line.Point2.y*(1-T1);
		tReturn.z = Line.Point1.z*T1 + Line.Point2.z*(1-T1);
		return true;
	}

	return false;
}

//---------------------------------------------------------------------
// AddGenerateBoundingSphere()
// 
// Usage: When first creating the plane, to generate its bounding sphere info
//
// Algorithm, basically takes the midpoint of a plane, probably only works properly if plane
//            is symetric
//---------------------------------------------------------------------
void PlaneObject::AddGenerateBoundingSphere()
{
	D3DXVECTOR3 t1,t2; 
	t1.x = Plane.v1.x - (Plane.v1.x - Plane.v2.x)/2.0f;
	t1.y = Plane.v1.y - (Plane.v1.y - Plane.v2.y)/2.0f;
	t1.z = Plane.v1.z - (Plane.v1.z - Plane.v2.z)/2.0f;

	t2.x = Plane.v3.x - (Plane.v3.x - Plane.v4.x)/2.0f;
	t2.y = Plane.v3.y - (Plane.v3.y - Plane.v4.y)/2.0f;
	t2.z = Plane.v3.z - (Plane.v3.z - Plane.v4.z)/2.0f;

	BoundingSphere.Center.x = t1.x - (t1.x - t2.x)/2.0f;
	BoundingSphere.Center.y = t1.y - (t1.y - t2.y)/2.0f;
	BoundingSphere.Center.z = t1.z - (t1.z - t2.z)/2.0f;

	BoundingSphere.Radius = sqrt(
					(BoundingSphere.Center.x - Plane.v1.x)*(BoundingSphere.Center.x - Plane.v1.x) +
					(BoundingSphere.Center.y - Plane.v1.y)*(BoundingSphere.Center.y - Plane.v1.y) +
					(BoundingSphere.Center.z - Plane.v1.z)*(BoundingSphere.Center.z - Plane.v1.z));
}

//---------------------------------------------------------------------
// IntersectBoundingBox(const Ray &Line)
// 
// Usage: Calculates the intersection of a line with this objects bounding box level of collision detection
//
// Algorithm, uses ray - plane intersection math
//---------------------------------------------------------------------
BOOL PlaneObject::IntersectBoundingBox(const RAY &Line, D3DXVECTOR3 &IntersectionPoint)
{
	return Math.IntersectPlane(Plane,Line,IntersectionPoint);

}

void PlaneObject::OnSelect()
{
	// change the color scheme
	VERTEX* pVertex; // pointer for traversal of VB
	if( SUCCEEDED( g_pPlaneVB->Lock(0, 0, (BYTE**)&pVertex, 0 ) ) )
	{
		{
			pVertex[0].color = SELECTCOLOR;
			pVertex[1].color = SELECTCOLOR;
			pVertex[2].color = SELECTCOLOR;
			pVertex[3].color = SELECTCOLOR;


			g_pPlaneVB->Unlock();
		}
	}

	StdObject::OnSelect();  // call the default

}

void PlaneObject::OnDeselect()
{
		// change the color scheme
	VERTEX* pVertex; // pointer for traversal of VB
	if( SUCCEEDED( g_pPlaneVB->Lock(0, 0, (BYTE**)&pVertex, 0 ) ) )
	{
		{
			pVertex[0].color = Color;
			pVertex[1].color = Color;
			pVertex[2].color = Color;
			pVertex[3].color = Color;


			g_pPlaneVB->Unlock();
		}
	}
	StdObject::OnDeselect();  // call the default

}
