// PlaneObject.h: interface for the PlaneObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PLANEOBJECT_H__B6A432BF_5489_4AE3_BE32_740B806F3ABE__INCLUDED_)
#define AFX_PLANEOBJECT_H__B6A432BF_5489_4AE3_BE32_740B806F3ABE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "StdObject.h"
#include "OctTree.h"
#include "UMath.h"
#include <stack>
#include <vector>

class OctNode;

#define SELECTCOLOR 0xffff0000

class PlaneObject : public StdObject
{
private: 
	PLANE Plane; // defines where the plane is
	Sphere BoundingSphere;
public:
	DWORD Color;
	void OnDeselect();
	void OnSelect();
	BOOL IntersectBoundingBox(const RAY &Line, D3DXVECTOR3 &IntersectionPoint);
	void AddGenerateBoundingSphere();
	BOOL IntersectBoundingSphere(const RAY &Line, D3DXVECTOR3 &IntersectionPoint);
	void Render(LPDIRECT3DDEVICE8 m_pd3dDevice);
	BOOL AddObjectToOcttree();
	PlaneObject();
	PlaneObject(PLANE Plane, DWORD Color);
	virtual ~PlaneObject();	

	LPDIRECT3DVERTEXBUFFER8 g_pPlaneVB; // Buffer to hold vertices

};

#endif // !defined(AFX_PLANEOBJECT_H__B6A432BF_5489_4AE3_BE32_740B806F3ABE__INCLUDED_)
