// RollOut.h: interface for the CRollOut class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ROLLOUT_H__435B91E7_E86F_49C4_98FA_DC4033A634DC__INCLUDED_)
#define AFX_ROLLOUT_H__435B91E7_E86F_49C4_98FA_DC4033A634DC__INCLUDED_

#include <list>
#include "ScrollView.h"	// Added by ClassView

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// This class provides functionality to have roll outs in a scrollview stype class just
// like 3ds max 4.0

// this should be the window size of the edit window, I expect this to stay the same
#define STDROWIDTH 200 // the roll out has a standard window width of 200

class ScrollView;

class CRollOut  
{
private:

	struct CS // or control struct name shortened because of debugger warning
	{
		CWnd *theControl;
		CRect RelativePosition; // in terms of to the roll out header
	};

	typedef std::list<CS*> CONTROLLIST;

	struct Group
	{
		CONTROLLIST ControlList;
		BOOL IsOpen; // is it open (viewable) or close (hidden)
		CRect OpenSize; // how big is it open?
		int CurrYOffset; // the current offset
		char Title[100];
	};

	typedef std::list<Group*> ROLLDOWNLIST;
	
	CPoint BitmapSize; // the size of the bitmap
	int AddYOffset; // when adding items this stores the offset
	int XOffset; // offset, set to center justify the bitmap
	int YSpacingOpen; // spacing between groups which is open
	int YSpacingClosed; // spacing between groups which are closed

	// this stores all of the groups that could be rolled down;
	ROLLDOWNLIST GroupList;

	// the bitmaps of the close and open roll out box
	CBitmap CloseGroup;
	CBitmap OpenGroup;

public:
	
	// goes through all of the window controls and adjust them for scrolling, works in tandem
	// with the scroll view window to scroll the window, used when resizing the height of the view
	// window and its complications with reposition the scroll bar.
	void ResetPositions();

	int GetTotalHeight(); // gets the total height of the roll out
	int GetCurrAddYOffset(); // gets the offset height, used when first adding stuff to the roll out

	// main functions to add stuff to the roll out
	void AddControltoGroup(CWnd *Ctrl, CRect AbsoluteRect);
	void AddGroup(char GroupTitle[100], BOOL IsOpen);

	// message handlers
	CPoint OnLButtonUp(UINT nFlags, CPoint Point);
	void OnPaint(CDC *pDC);

	ScrollView *ScrollViewPtr; // used to get offsets of the scroll view window

	// basic check inlined for the heck of it
	inline BOOL PointInRect(const CPoint &Point, const CRect &Rect, const int &YOffset)
	{
		CPoint tPoint = Point;
		tPoint.y -= YOffset; // quick way to fix the offset
		if (Rect.top < tPoint.y && tPoint.y < Rect.bottom)
			if (Rect.left < tPoint.x && tPoint.x < Rect.right)
				return true;

		return false;
	}

	CRollOut();
	virtual ~CRollOut();

};

#endif // !defined(AFX_ROLLOUT_H__435B91E7_E86F_49C4_98FA_DC4033A634DC__INCLUDED_)
