// ScrollView.cpp : implementation file
//

#include "stdafx.h"
#include "MapEditor.h"
#include "ScrollView.h"
#include "ChildView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// ScrollView

ScrollView::ScrollView()
{
	ScrollBarWidth = 16;
	// Offsets for BitBlt
	HorzCurrScroll = 0;
	VertCurrScroll = 0;
	VertPrevPosition = 0;
	HorzPrevPosition = 0;
	HorzEnabled = false;
	VertEnabled = false;
	EditObjectPtr = NULL;
}

ScrollView::~ScrollView()
{
	GetViewPtr()->EditView.ScrollViewPtr = NULL;
}


BEGIN_MESSAGE_MAP(ScrollView, CWnd)
	//{{AFX_MSG_MAP(ScrollView)
	ON_WM_CREATE()
	ON_WM_PAINT()
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// ScrollView message handlers

//==============================================================================
//
// OnCreate(LPCREATESTRUCT lpCreateStruct) 
//
// Usage: Windows Framework, creates the vertical scroll bar
//
//==============================================================================
int ScrollView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

/*	// Actually create the scrollbars however don't make them visible
	HorzRect.left = WindowSize.left;
	HorzRect.right = WindowSize.right - ScrollBarWidth;
	HorzRect.bottom = WindowSize.Height();
	HorzRect.top = WindowSize.Height() - ScrollBarWidth;*/

	VertRect.left = WindowSize.Width() - ScrollBarWidth;
	VertRect.right = WindowSize.Width();
	VertRect.top = 0;
	VertRect.bottom = WindowSize.Height();// - ScrollBarWidth; // don't want to overlap with the horz bar

//	HorizontalBar.Create(SBS_HORZ /*| SBS_BOTTOMALIGN */| WS_CHILD | WS_VISIBLE , HorzRect, this, HORZSCROLLBAR);
	VerticalBar.Create(SBS_VERT  /*| SBS_RIGHTALIGN*/| WS_CHILD | WS_VISIBLE , VertRect, this, VERTSCROLLBAR);
	SetScrollBars();
	
	return 0;
}

//==============================================================================
//
// Create(CRect WindowSize, CPoint ViewSize, CWnd *ParentPtr)
//
// Usage: Has to be called to initialize the scroll view
//
// Note: Assigns itself to the main views window as the edit window
//==============================================================================
void ScrollView::Create(CRect WindowSize, CPoint ViewSize, CWnd *ParentPtr)
{
	char windowname[40]; 

    strcpy(windowname,AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		        ::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL));

    // Set the window's initial style
    DWORD m_dwWindowStyle = WS_VISIBLE | WS_CHILD ;

	this->WindowSize.top = 0;
	this->WindowSize.left = 0;
	this->WindowSize.bottom = WindowSize.Height();
	this->WindowSize.right = WindowSize.Width();	

	this->ViewSize.top = 0;
	this->ViewSize.left = 0;
	this->ViewSize.right = ViewSize.x;
	this->ViewSize.bottom = ViewSize.y;

    // Create the render window 
    CreateEx(0  ,windowname,"EditObjectViewWindow",m_dwWindowStyle,WindowSize,ParentPtr,50,NULL);

	this->ParentPtr = ParentPtr;

	ASSERT(GetViewPtr()->EditView.ScrollViewPtr == NULL);
	GetViewPtr()->EditView.ScrollViewPtr = this;


}

//==============================================================================
//
// OnPaint() 
//
// Usage: Windows message handler, creates a double buffer, fills the background with grey
//	      and then calls the hopefully overriden function Paint() to allow for the child class
//        to paint
//
// Note: Calls a timekeeping function at the end to see how long it took
//==============================================================================
void ScrollView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	CRect ActualSize;
	// pick the appropraite size, minimum the window size
	if (WindowSize.Height() > ViewSize.Height())
		ActualSize = WindowSize;
	else
		ActualSize = ViewSize;
	
		// form the double buffer for the stats area
	CDC DBufferDC;
    DBufferDC.CreateCompatibleDC(&dc);
    CBitmap DBufferBitmap;
	if (WindowSize.Height() > ViewSize.Height())
		DBufferBitmap.CreateCompatibleBitmap(&dc,ActualSize.Width(),ActualSize.Height());
	else
		DBufferBitmap.CreateCompatibleBitmap(&dc,ActualSize.Width(),ActualSize.Height());
	CBitmap *pOldBitmap = DBufferDC.SelectObject(&DBufferBitmap);

	// draw the background
	CBrush Brush(RGB(197,197,197)); // grey
	DBufferDC.FillRect(&ActualSize,&Brush);

	// figure out the Width and Height
	int Width;
	if (VertEnabled)
		Width = WindowSize.Width()-ScrollBarWidth;
	else
		Width = ViewSize.Width();

	int Height;
/*	if (HorzEnabled)
		Height = WindowSize.Height()-ScrollBarWidth;
	else*/
	Height = WindowSize.Height();

	Paint(&DBufferDC); // for the inherted class to have it own painting

	// bitblt the double buffer but be sure to use the scroll offset
    dc.BitBlt(0,0,Width,Height,&DBufferDC,-HorzCurrScroll,-VertCurrScroll,SRCCOPY);
    DBufferDC.SelectObject(pOldBitmap);

	// time keep the amount of time it took to draw this thing
	LARGE_INTEGER endtime;    
    ::QueryPerformanceCounter(&endtime);
    ((CChildView *)ParentPtr)->SEDT(endtime);

}

//==============================================================================
//
// GetInvalidateRect()
//
// Usage: Returns the currently displayed rectange minus the scroll bars which don't
//        have to be invalidated
//
//==============================================================================
CRect ScrollView::GetInvalidateRect()
{
	CRect tReturn = WindowSize;

	CRect ScrollBarSize;

/*	HorizontalBar.GetWindowRect(&ScrollBarSize);
	if (HorzEnabled)
		tReturn.bottom -= ScrollBarSize.Height();
*/
	VerticalBar.GetWindowRect(&ScrollBarSize);
	if (VertEnabled)
		tReturn.right -= ScrollBarSize.Width();


	return tReturn;

}
//==============================================================================
//
// SetScrollBars()
//
// Usage: This function is called on the OnCreate handler to set the scroll bars
//        However it isn't that important anymore since the view size and scroll bars
//        are dynamically altered
//
//==============================================================================
void ScrollView::SetScrollBars()
{
	int ScrollBarWidth = 16;

	// check if it is necessary to have a horizontal scroll bar
/*	if (ViewSize.Width() + 16 <= WindowSize.Width())
	{
		// not neccessary make it invisible
		HorizontalBar.ShowScrollBar(false);
		HorzEnabled = false;
	}
	else
	{
		// it is neccessary, set the range of the scroll bar
		SCROLLINFO structure;
		structure.cbSize = sizeof(SCROLLINFO);
		structure.fMask = SIF_ALL; 
		structure.nMin = 0; 
		structure.nMax = ViewSize.Width(); 
		HorzPageSize = structure.nPage = WindowSize.Width()-16; 
	    structure.nPos = 0; 
	    structure.nTrackPos = 0; // ignores this one 
		HorizontalBar.SetScrollInfo(&structure);
		HorzPrevPosition = 0;
		HorizontalBar.ShowScrollBar(true);
		HorzEnabled = true;
	}*/
	// check if it is necessary to have a horizontal scroll bar
	if (ViewSize.Height() <= WindowSize.Height())
	{
		// not neccessary make it invisible
		VerticalBar.ShowScrollBar(false);
		VertEnabled = false;
	}
	else
	{
		// it is neccessary, set the range of the scroll bar
		SCROLLINFO structure;
		structure.cbSize = sizeof(SCROLLINFO);
		structure.fMask = SIF_ALL; 
		structure.nMin = 0; 
		structure.nMax = ViewSize.Height(); 
		VertPageSize = structure.nPage = WindowSize.Height()-16; 
	    structure.nPos = 0; 
	    structure.nTrackPos = 0; // ignores this one 
		VerticalBar.SetScrollInfo(&structure);
		VertPrevPosition = 0;
		VerticalBar.ShowScrollBar(true);
		VertEnabled = true;
	}

}

//==============================================================================
//
// ResetVerticalSize(int NewSize)
//
// Usage: Gut function.  Resizes view window, scroll bars, scroll position based on a new
//        size, e.i when a roll out has been expanded or contracted and the height of the window
//        is required to change.
//
// Notes: Calls OnResetSize() which allow the roll out to do some of the client window control
//        scrolling, because I was having large problems with the ScrooWindowEx function call
//==============================================================================
void ScrollView::ResetVerticalSize(int NewSize)
{

	int newPos =  NewSize - ViewSize.Height();
	ViewSize.bottom = NewSize;

	if (ViewSize.Height() <= WindowSize.Height())
	{
		// If the scroll bar isn't required anymore because the view window is now smaller
		// then the physical window
		// essentially disable the scroll bar
		SCROLLINFO structure;
		structure.cbSize = sizeof(SCROLLINFO);
		structure.fMask = SIF_ALL | SIF_DISABLENOSCROLL;  
		structure.nMin = 0; 
		structure.nMax = 0; 
		structure.nPage = 1; 
		structure.nPos = 0;
		VerticalBar.SetScrollInfo(&structure);
		// not neccessary make it invisible
		VerticalBar.ShowScrollBar(true);

		VertCurrScroll = VertPrevPosition = 0;
		OnResetSize();
		VertEnabled = false;
	}
	else
	{
		// Reset the size of the scroll bar due to the size change
		SCROLLINFO structure;
		structure.cbSize = sizeof(SCROLLINFO);
		structure.fMask = SIF_ALL; 
		structure.nMin = 0; 
		structure.nMax = ViewSize.Height(); 
		VertPageSize = structure.nPage = WindowSize.Height()-16; 
		
		if (VertCurrScroll != 0)
		{

			int Difference = newPos;

			// don't want to scroll past the 0 position
			if (VertCurrScroll > Difference)
				Difference = VertCurrScroll;

			VerticalBar.MoveWindow(&VertRect,false);
			VerticalBar.Invalidate(false);
			VerticalBar.UpdateWindow();

			// don't want to scroll past the 0 position
			VertCurrScroll -= Difference;
			if (VertCurrScroll > 0)
				VertCurrScroll = 0;
			VertPrevPosition = structure.nPos  = - VertCurrScroll;
			OnResetSize();  // get the roll out manager to reset the window positions

		}
		else
		{
			structure.nPos = 0;
			VertPrevPosition = 0;
		}

		structure.nTrackPos = 0; // ignores this one 
		VerticalBar.SetScrollInfo(&structure);

		VerticalBar.ShowScrollBar(true);
		VertEnabled = true;
	}
		InvalidateRect(GetInvalidateRect(),false);
}

//==============================================================================
//
// OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
//
// Usage: Gut function for scrolling the window based on changes on the horizontal scroll bar
//
// Notes: Note used anymore because the horizontal scroll bar is disabled
//==============================================================================
void ScrollView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	int SlowScrollSpeed = 5;
	int FastScrollSpeed = 15;
	int CurrPos = HorizontalBar.GetScrollPos();
	int OldCurrPos = CurrPos;
	int Difference = 0;
	if (nSBCode == SB_LEFT)
	{	
		CurrPos -= FastScrollSpeed;
		if (CurrPos < 0)
			CurrPos = 0;
		HorizontalBar.SetScrollPos(CurrPos);	
	}
	else if (nSBCode == SB_ENDSCROLL) // when the end of the scroll bar has been reached, ignored
	{}
	else if (nSBCode == SB_LINELEFT) // the left arrow box
	{	
		CurrPos -= SlowScrollSpeed;
		if (CurrPos < 0)
			CurrPos = 0;
		HorizontalBar.SetScrollPos(CurrPos);		
	}
	else if (nSBCode == SB_LINERIGHT) // the right arrow box
	{	
		CurrPos += SlowScrollSpeed;
		if (CurrPos + HorzPageSize > ViewSize.Width() )
			CurrPos = ViewSize.Width() - HorzPageSize;
		HorizontalBar.SetScrollPos(CurrPos);	
	}
	else if (nSBCode == SB_PAGELEFT)
	{
		CurrPos -= HorzPageSize;
		if (CurrPos < 0)
			CurrPos = 0;
		HorizontalBar.SetScrollPos(CurrPos);	
	}
	else if (nSBCode == SB_PAGERIGHT)
	{
		CurrPos += HorzPageSize;
		if (CurrPos + HorzPageSize > ViewSize.Width() )
			CurrPos = ViewSize.Width() - HorzPageSize;
		HorizontalBar.SetScrollPos(CurrPos);	
	}
	else if (nSBCode == SB_RIGHT)
	{
		CurrPos += FastScrollSpeed;
		if (CurrPos + HorzPageSize > ViewSize.Width() )
			CurrPos = ViewSize.Width() - HorzPageSize;
		HorizontalBar.SetScrollPos(CurrPos);		
	}
	else if (nSBCode == SB_THUMBPOSITION) // new position of the thumb
	{
		HorizontalBar.SetScrollPos(nPos,true);
		Difference = HorzPrevPosition - nPos;	
	}
	else if (nSBCode == SB_THUMBTRACK) // user has manually pushed it
	{
		HorizontalBar.SetScrollPos(nPos,true);
		Difference = HorzPrevPosition - nPos;
	}

	// scroll the window
	if (Difference == 0) // check to see if it has been changed by SB_THUMBPOSITION
		Difference = OldCurrPos - CurrPos; // figure out the differece	

	// this is neccessary because if not, some windows will be lost to the scroll window, when there
	// scrolled out of the immediaa GetInvalidateRect()
	CRect Rect = GetInvalidateRect();
	Rect.left = - ViewSize.Width();
	Rect.top = -ViewSize.Height();
	// Do the actual scrolling
	ScrollWindowEx(Difference,0,Rect,NULL,NULL,NULL,SW_SCROLLCHILDREN|SW_ERASE|SW_INVALIDATE );

	// any windows
	HorzCurrScroll += Difference;  // record the new offset
	HorzPrevPosition = HorizontalBar.GetScrollPos();
	// now adjust the scroll bars to their original position so they doesn't move
	// now adjust the scroll bars to their original position so they doesn't move
	HorizontalBar.MoveWindow(&HorzRect,false);
	HorizontalBar.Invalidate(false);
	HorizontalBar.UpdateWindow();
	VerticalBar.MoveWindow(&VertRect,false);
	VerticalBar.Invalidate(false);
	VerticalBar.UpdateWindow();

	// update the thing so it redraws immediatly
//	InvalidateRect(GetInvalidateRect(),false);
//	UpdateWindow();
	
	CWnd::OnHScroll(nSBCode, nPos, pScrollBar);
}

//==============================================================================
//
// OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
//
// Usage: Gut function for scrolling the window based on changes on the horizontal scroll bar
//
// Notes: First scrolls the window, then change the scroll offsets stored in this class, so
//        the double buffer in the onpaint function is blitted at the right place
//==============================================================================
void ScrollView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	int SlowScrollSpeed = 5;
	int FastScrollSpeed = 15;
	int Difference = 0;
	int CurrPos = VerticalBar.GetScrollPos();
	int OldCurrPos = CurrPos;

	if (nSBCode == SB_TOP )
	{		
		CurrPos -= FastScrollSpeed;
		if (CurrPos < 0)
			CurrPos = 0;
		VerticalBar.SetScrollPos(CurrPos);	
	}
	else if (nSBCode == SB_ENDSCROLL) // when the end of the scroll bar has been reached, ignored
	{}
	else if (nSBCode == SB_LINEUP) // the left arrow box
	{		
		CurrPos -= SlowScrollSpeed;
		if (CurrPos < 0)
			CurrPos = 0;
		VerticalBar.SetScrollPos(CurrPos);
	}
	else if (nSBCode == SB_LINEDOWN ) // the right arrow box
	{
		CurrPos += SlowScrollSpeed;
		if (CurrPos + VertPageSize > ViewSize.Height() )
			CurrPos = ViewSize.Height() - VertPageSize + 1;
		VerticalBar.SetScrollPos(CurrPos);
	}
	else if (nSBCode == SB_PAGEUP)
	{	
		CurrPos -= VertPageSize;
		if (CurrPos < 0)
			CurrPos = 0;
		VerticalBar.SetScrollPos(CurrPos);		
	}
	else if (nSBCode == SB_PAGEDOWN )
	{	
		CurrPos += VertPageSize;
		if (CurrPos + VertPageSize > ViewSize.Height() )
			CurrPos = ViewSize.Height() - VertPageSize + 1;
		VerticalBar.SetScrollPos(CurrPos);			
	}
	else if (nSBCode == SB_BOTTOM)
	{		
		CurrPos += FastScrollSpeed;
		if (CurrPos + VertPageSize > ViewSize.Height() )
			CurrPos = ViewSize.Height() - VertPageSize + 1;
		VerticalBar.SetScrollPos(CurrPos);	
	}
	else if (nSBCode == SB_THUMBPOSITION) // new position of the thumb
	{
		VerticalBar.SetScrollPos(nPos,true);
		Difference = VertPrevPosition - nPos;		
		
	}
	else if (nSBCode == SB_THUMBTRACK) // user has manually pushed it
	{
		VerticalBar.SetScrollPos(nPos,true);
		Difference = VertPrevPosition - nPos;
	}

	// scroll the window
	if (Difference == 0) // check to see if it has been changed by SB_THUMBPOSITION
		Difference = OldCurrPos - CurrPos; // figure out the differece
	// this is neccessary because if not, some windows will be lost to the scroll window, when there
	// scrolled out of the immediaa GetInvalidateRect()

	VertCurrScroll += Difference; // record the new offset

	// form the rectange of the region that is to be scrolled, use the entire view window for this
	CRect Rect = GetInvalidateRect();
	Rect.left = - ViewSize.Width();
	Rect.top = -ViewSize.Height();
	Rect.bottom += ViewSize.Height();

	// actually scroll the window
	ScrollWindowEx(0,Difference,Rect,NULL,NULL,NULL,SW_SCROLLCHILDREN | SW_ERASE|SW_INVALIDATE);

	VertPrevPosition = VerticalBar.GetScrollPos();// record the old (current) position
	// now adjust the scroll bars to their original position so they doesn't move
/*	HorizontalBar.MoveWindow(&HorzRect,false);
	HorizontalBar.Invalidate(true);
	HorizontalBar.UpdateWindow();*/
	VerticalBar.MoveWindow(&VertRect,false);
	VerticalBar.Invalidate(false);
	VerticalBar.UpdateWindow();

	CWnd::OnVScroll(nSBCode, nPos, pScrollBar);
}

//==============================================================================
//
// SetEditObject(StdObject *EditObjectPtr) 
//
// Usage: To store a reference to the object being edited with this view.
//
//==============================================================================
void ScrollView::SetEditObject(StdObject *EditObjectPtr)
{
	this->EditObjectPtr = EditObjectPtr;
}

//==============================================================================
//
// GetCurrentScrollOffset()
//
// Usage: Returns the current scroll offset
//
//==============================================================================
CPoint ScrollView::GetCurrentScrollOffset()
{
	CPoint tReturn;
	tReturn.x = HorzPrevPosition;
	tReturn.y = VertPrevPosition;
	return tReturn;
}

//==============================================================================
//
// GetViewSize()
//
// Usage: Returns the size of the view window (not the physical window)
//
//==============================================================================
CRect ScrollView::GetViewSize()
{
	return ViewSize;
}

//==============================================================================
//
// ReDrawBars()()
//
// Usage: Called to redraw the scroll bars
//
//==============================================================================
void ScrollView::ReDrawBars()
{
//	HorizontalBar.Invalidate(false);
//	HorizontalBar.UpdateWindow();

	VerticalBar.Invalidate(false);
	VerticalBar.UpdateWindow();

}

