// StdObject.cpp: implementation of the StdObject class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MapEditor.h"
#include "StdObject.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

StdObject::StdObject()
{
	RenderFlag = 0;
	PrevChangedFlag = 0;
	Selected = false;
	GroupPtr = new GroupStruct(this);
	EditView = NULL;
}

StdObject::~StdObject()
{
	delete GroupPtr;

	if (EditView!= NULL)
	{
		delete EditView;
		EditView = NULL;
	}


}
//---------------------------------------------------------------------
// DeleteObjectFromOctree()
// 
//---------------------------------------------------------------------
void StdObject::DeleteObjectFromOctree()
{

}


//---------------------------------------------------------------------
// UAddPlanetoOctree(PLANE Plane)
// 
// Usage: Utility function which adds a plane to the octree
//---------------------------------------------------------------------
BOOL StdObject::UAddPlanetoOctree(PLANE Plane)
{
	OctNodePtr tOctNodePtr = theOctTree.GetHeadOctNode();
	OctNodePtr tHeadOctNodePtr = tOctNodePtr;

	BOOL GotAllOct;

	ASSERT(tOctNodePtr != NULL); // should never happen

	// 1) Check if plane is valid
	if (!tOctNodePtr->Area.PointinCube(Plane.v1))
		return false;
	if (!tOctNodePtr->Area.PointinCube(Plane.v2))
		return false;;
	if (!tOctNodePtr->Area.PointinCube(Plane.v3))
		return false;;
	if (!tOctNodePtr->Area.PointinCube(Plane.v4))
		return false;;

	// 2) search for the leaf octnode of V1 of plane
	while (tOctNodePtr->Children[0] != NULL)
	{
		int newIndex = theOctTree.UGetChildIndex(tOctNodePtr->Area,Plane.v1,tOctNodePtr);

		tOctNodePtr = tOctNodePtr->Children[newIndex];
	}

	// 3) O.K now check if all of the other verteces are there
	GotAllOct = false;

	if (tOctNodePtr->Area.PointinCube(Plane.v2))
		if (tOctNodePtr->Area.PointinCube(Plane.v3))
			if (tOctNodePtr->Area.PointinCube(Plane.v4))
			{
				// add object just to this cube
				OctList.push_back(tOctNodePtr);
				GotAllOct = true;
			}

	// 4) check if perhaps verteces are in its neighbours
	OctNodePtr t1,t2,t3; // temp node pointers for neighbour storage
	t1 = t2 = t3 = NULL;	
	if (!GotAllOct)
	{
		GotAllOct = true;; // not in the neighbours
		// check out v2;
		if (tOctNodePtr->Area.PointinCube(Plane.v2))
		{
			// don't want to continue looking if in the current node
		}
		else
		{
			for (int ix = 0; ix < 6; ix++)
			{
				if (tOctNodePtr->Neighbours[ix] != NULL)
				{
					if (tOctNodePtr->Neighbours[ix]->Area.PointinCube(Plane.v2))
					{
						// garbage code, in case the nieghbours hold all of the values,
						// the neighbours have to be put into variables for futures use, which 
						// is done below.
						if ((tOctNodePtr->Neighbours[ix] != t1) &&
							(tOctNodePtr->Neighbours[ix] != t2) &&
							(tOctNodePtr->Neighbours[ix] != t3))
						{									
							t1 = tOctNodePtr->Neighbours[ix];						
							
						}
						break;
					}
				}
			}
			if (ix == 6)
			{
				GotAllOct = false;		
			}
		}
		if (GotAllOct)
		{
			// check out v3;
			if (tOctNodePtr->Area.PointinCube(Plane.v3))
			{
				// don't want to continue looking if in the current node
			}
			else
			{
				for (int ix = 0; ix < 6; ix++)
				{
					if (tOctNodePtr->Neighbours[ix] != NULL)
					{
						if (tOctNodePtr->Neighbours[ix]->Area.PointinCube(Plane.v3))
						{
							// garbage code, in case the nieghbours hold all of the values,
							// the neighbours have to be put into variables for futures use, which 
							// is done below.
							if ((tOctNodePtr->Neighbours[ix] != t1) &&
								(tOctNodePtr->Neighbours[ix] != t2) &&
								(tOctNodePtr->Neighbours[ix] != t3))
							{
								if (t1 == NULL)						
									t1 = tOctNodePtr->Neighbours[ix];						
								else 						
									t2 = tOctNodePtr->Neighbours[ix];
							}
							break;
						}
					}
				}
				if (ix == 6)
				{
					GotAllOct = false;			
				}
			}
		}
		if (GotAllOct)
		{
			// check out v4;
			if (tOctNodePtr->Area.PointinCube(Plane.v4))
			{	
				// don't want to continue looking if in the current node
			}
			else
			{
				for (int ix = 0; ix < 6; ix++)
				{
					if (tOctNodePtr->Neighbours[ix] != NULL)
					{
						if (tOctNodePtr->Neighbours[ix]->Area.PointinCube(Plane.v4))
						{
							// garbage code, in case the nieghbours hold all of the values,
							// the neighbours have to be put into variables for futures use, which 
							// is done below.
							if ((tOctNodePtr->Neighbours[ix] != t1) &&
								(tOctNodePtr->Neighbours[ix] != t2) &&
								(tOctNodePtr->Neighbours[ix] != t3))
							{
								if (t1 == NULL)						
									t1 = tOctNodePtr->Neighbours[ix];						
								else if (t2 == NULL)						
									t2 = tOctNodePtr->Neighbours[ix];						
								else
									t3 = tOctNodePtr->Neighbours[ix];
							}
							break;
						}
					}
				}
				if (ix == 6)
				{
					GotAllOct = false;				
				}
			}
		}
		// O.K so it is contained in the nieghbours.  Then add the nieghbours into the list
		if (GotAllOct)
		{
				OctList.push_back(tOctNodePtr);
				if (t1 != NULL)				
					OctList.push_back(t1);				
				if (t2 != NULL)
					OctList.push_back(t2);
				if (t3 != NULL)
					OctList.push_back(t3);
		}
	}
	// 5) Do an plane to plane intersection test on the neighbours to find the intersection points
	if (!GotAllOct)
	{
		OCTNODELIST OctNodeList;
		OctNodeList.push(tOctNodePtr);
		int InteratorFlag = tHeadOctNodePtr->Flag + 1; // get the iterator int.
		tOctNodePtr->Flag = InteratorFlag; // flag this node so it isn't visited again

		while (!OctNodeList.empty())
		{			 
			tOctNodePtr = OctNodeList.top();
			OctNodeList.pop(); // pop it out here
			// add into node list here
			OctList.push_back(tOctNodePtr);

			// check each neighbour and add into stack as we go along
			for (int ix = 0; ix < 6; ix++)
			{
				if (tOctNodePtr->Neighbours[ix] != NULL)
				{
					if (tOctNodePtr->Neighbours[ix]->Flag != InteratorFlag)
					{
						// do collision test here
						PLANE TestPlane;
						TestPlane = theOctTree.UGetPlane(tOctNodePtr,ix);
						if (Math.IntersectPlane(Plane,TestPlane))
						{
							OctNodeList.push(tOctNodePtr->Neighbours[ix]); // add it to the stack if it intersects the plane
							tOctNodePtr->Neighbours[ix]->Flag = InteratorFlag; // flag it so it isn't visited again
						}
						
					}
				}
			}
		}
		tHeadOctNodePtr->Flag = InteratorFlag;
	}

	// 6) Got the list, add the list to the octree
	
	theOctTree.AddStartSequence();
	OCTLIST::iterator curr = OctList.begin();
	OCTLIST::iterator end = OctList.end();
	while (curr != end)
	{
		// add the object to the octnode
		theOctTree.AddObjecttoNode(this,*curr);		
		curr++;
	}

	return true;

}

//---------------------------------------------------------------------
// URemoveObjectfromOctree()
// 
// Usage: Removes the object from the octree by using the list generated when adding it
//        to the octree
//---------------------------------------------------------------------
void StdObject::URemoveObjectfromOctree()
{
	theOctTree.AddStartSequence();
	OCTLIST::iterator curr = OctList.begin();
	OCTLIST::iterator end = OctList.end();
	while (curr != end)
	{
		// remove the object to the octnode
		theOctTree.RemoveObjectfromNode(this,*curr);
		BOOL Done = false;
		OctNode *theNode = (*curr);
		curr++;
	}
	OctList.clear();
}
