// StdObject.h: interface for the StdObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_STDOBJECT_H__48C4D367_4231_42E9_AA25_5B642CE0BA23__INCLUDED_)
#define AFX_STDOBJECT_H__48C4D367_4231_42E9_AA25_5B642CE0BA23__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "OctTree.h"
#include "GroupStruct.h"
#include "ScrollView.h"
#include "UMath.h"
#include <stack>
#include <vector>
#include <list>


class OctNode;
class GroupStruct;
class ScrollView;

typedef std::list<OctNode*> OCTLIST;

class StdObject;
typedef class StdObject *StdObjectPtr;
typedef class OctNode *OctNodePtr;

typedef std::stack<OctNodePtr, std::vector<OctNodePtr> > OCTNODELIST;

class StdObject  
{
public:
	void URemoveObjectfromOctree();
	virtual void DeleteObjectFromOctree();

	// these function should be overridden by every inheritance
	virtual void AddObjectToOctree() {};
	virtual void Render(LPDIRECT3DDEVICE8 m_pd3dDevice) {};

	// Collision detection functions that should be overridden
	virtual BOOL IntersectBoundingSphere(const RAY &Line, D3DXVECTOR3 &IntersectionPoint) { return FALSE;}
	virtual BOOL IntersectBoundingSphere(const Sphere &sphere) { return FALSE;}
	virtual BOOL IntersectBoundingBox(const RAY &Line, D3DXVECTOR3 &IntersectionPoint) { return FALSE;}
	virtual BOOL IntersectBoundingBox(const FCube &Box) { return FALSE;}

	// overide these if there is some custom stuff such as changed the color scheme, or rendering the bounding box etc
	virtual void OnSelect() { Selected = true; };
	virtual void OnDeselect() { Selected = false; };
	virtual BOOL isSelected() { return Selected;};

	int RenderFlag; // rending flag, render object only once per frame
	int PrevChangedFlag; // used in the terrian tools
	BOOL Selected; // if the object is selected or not

	ScrollView *EditView; // support for an interface to edit the object

	GroupStruct *GroupPtr; // group ptr support

	StdObject();
	virtual ~StdObject();

	OCTLIST OctList;
protected:
	BOOL UAddPlanetoOctree(PLANE Plane);
};

#endif // !defined(AFX_STDOBJECT_H__48C4D367_4231_42E9_AA25_5B642CE0BA23__INCLUDED_)
