// TerrainManager.h: interface for the TerrainManager class.
//
// This class has some higher level functionality that makes it easy to edit the terrian (tiles)
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TERRAINMANAGER_H__D6B25FED_D617_435E_AEC6_4D2948516D02__INCLUDED_)
#define AFX_TERRAINMANAGER_H__D6B25FED_D617_435E_AEC6_4D2948516D02__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "TileObject.h"
#include <stack> 
#include <vector>
#include <list>



class TerrainManager  
{
public:

	// Due to the global nature and effiency there are several flags and flag functions
	// only reset the tiles in the octree if they have been changed
	BOOL ChangeTerrainChanged;
	void InvalidateTerrainChanged();
	
	// called during the octree destructer call, don't want any of the other global functions
	// to be executed
	void TerrainInvalid();
	BOOL TerrainValid;

	// this function resets every tile in the octree
	void ResetTerrainInOctree();

	// want to keep the same vertex buffer unless the data has changed, causes a performance
	// increase
	BOOL RenderingTerrainChanged;
	void InvalidateTerrainRender();

	int RenderFlag; // counter used for the stack style traversal of rendering and others

	// used to execute a 3D math function over the terrain
	void ExecuteFunction(TileObject *CenterTilePtr, const float ArgsPassed[], float (*pt2Func)(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]));
	// slightly different then above, used for an additive function not an absolute one
	void ExecuteFunctionA(TileObject *CenterTilePtr, const float ArgsPassed[], float (*pt2Func)(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]));
	// this version adds the base height of the center tile to the return value of the function
	void ExecuteFunctionB(TileObject *CenterTilePtr, const float ArgsPassed[], float (*pt2Func)(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]));


	// used to allow undo of current math function but not previous
	int PrevChangedFlag; // counter used for the stack style traversal
	void OnSelectNewTile(); // increments prevchanged flag
	// destructer
	void ResetTerrianManager();

	// rendering support
	BOOL Once;
	int NumberofTiles;
	void RenderFormPlane(VERTEX* &pVertex, PLANE Plane, DWORD Color);
	void RenderTiles1(LPDIRECT3DDEVICE8 m_pd3dDevice); // using triangle lists
	void RenderTiles(LPDIRECT3DDEVICE8 m_pd3dDevice); // using triangle strips

	// For rendering not that important right now
	TileObject *HeadRenderingTilePtr;

	// generates a flat terrian
	void GenerateTerrain(int XSegments, int ZSegments, float DepthLevel);

	TerrainManager();
	virtual ~TerrainManager();

	LPDIRECT3DVERTEXBUFFER8 g_pTileVB; // Buffer to hold vertices

};

extern TerrainManager theTerrainManager; // global reference

#endif // !defined(AFX_TERRAINMANAGER_H__D6B25FED_D617_435E_AEC6_4D2948516D02__INCLUDED_)
