// UMath.h: interface for the UMath class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_UMATH_H__C4435203_5511_47B6_867B_0E2A1FF0D695__INCLUDED_)
#define AFX_UMATH_H__C4435203_5511_47B6_867B_0E2A1FF0D695__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// standard includes
#include <D3D8.h>
#include "D3DApp.h"
#include "D3DUtil.h"
#include "D3DFile.h"
#include "DXUtil.h"
#include "D3DRes.h"

// math utility library
#define EXITCODE -9999.9f

#define PI (float)3.1415926535

class FCube
{
public:
		
	/************************************************************************
	* Function PointinCube(FCube &Cube, D3DVECTOR &Point)
	* 
	* returns if a point is in a cube
	* By convention the < get the equal not the >
	*************************************************************************/
	inline BOOL PointinCube(D3DVECTOR &Point)
	{
		if (Point.x <= tX)
			if (Point.x >= bX)
				if (Point.y <= tY)
					if (Point.y >= bY)
						if (Point.z <= tZ)
							if (Point.z >= bZ)
								return true;
		return false;
	}

	float tY;
	float bY;
	float tX;
	float bX;
	float tZ;
	float bZ;

	inline float Width() { return tZ-bZ;}
	inline float Height() { return tY-bY;}
	inline float Length() { return tX-bX;}
	
};

#define MAXGRIDVERTEXCOUNT 100000

enum { VERTEX_TYPE = D3DFVF_XYZ|D3DFVF_DIFFUSE | D3DFVF_TEX1};

struct VERTEX
{
	D3DXVECTOR3 position; // Object space position for the vertex.
	//float w;
	DWORD color;		  // The vertex color.
	FLOAT tu,tv;		  // The texture co-ordinates
};

enum { LINEVERTEX_TYPE = D3DFVF_XYZ|D3DFVF_DIFFUSE};

struct LINEVERTEX
{
	D3DXVECTOR3 position; // Object space position for the vertex.
	DWORD color;
};

class PLANE
{
public:
	D3DXVECTOR3 v1,v2,v3,v4;
	float pA,pB,pC,pD;
	inline PLANE() { }
	inline PLANE(D3DXVECTOR3 V0, D3DXVECTOR3 V1, D3DXVECTOR3 V2, D3DXVECTOR3 V3) 
	{
		v1 = V0;
		v2 = V1;
		v3 = V2;
		v4 = V3;
	}
};

////////////////////////
// A structure representing the verticies of a triangle
class Triangle
{
	public:
	D3DXVECTOR3 v0;
	D3DXVECTOR3 v1;
	D3DXVECTOR3 v2;

	inline Triangle() { }

	inline Triangle(D3DXVECTOR3 V0, D3DXVECTOR3 V1, D3DXVECTOR3 V2) 
	{
		v0 = V0;
		v1 = V1;
		v2 = V2;
	}
	/*inline operator= (Triangle RHS)
	{
		v0 = RHS.v0;
		v1 = RHS.v1;
		v2 = RHS.v2;
	}*/


};

////////////////////////
// A structure representing a sphere
class Sphere
{
	public:
	D3DXVECTOR3 Center;
	float Radius;

	inline Sphere() { }

	inline Sphere(D3DXVECTOR3 Center, float Radius ) 
	{
		this->Center = Center;
		this->Radius = Radius;		
	}
	/*inline operator= (Triangle RHS)
	{
		v0 = RHS.v0;
		v1 = RHS.v1;
		v2 = RHS.v2;
	}*/


};

///////////////////////////
// A structure representing a 3d ray (point-parallel form of a line)
struct RAY
{
	D3DXVECTOR3 origin;
	D3DXVECTOR3 direction;
};

///////////////////////////
// A structure representing a 3d line (point-parallel form of a line)
class LINE
{
public:
	D3DXVECTOR3 Point1;
	D3DXVECTOR3 Point2;

	inline LINE(const RAY &Ray) 
	{
		Point1 = Ray.origin;
		Point2.x = Ray.origin.x + Ray.direction.x*1000;
		Point2.y = Ray.origin.z + Ray.direction.y*1000;
		Point2.z = Ray.origin.y + Ray.direction.z*1000;
	}
	inline LINE() {};
};

class UMath  
{
public:

	// helper function
	float GetDistance(const D3DXVECTOR3 &PointOne, const D3DXVECTOR3 &PointTwo);

	// helper function
	inline float GetDistance2(const D3DXVECTOR3 &PointOne, const D3DXVECTOR3 &PointTwo)
	{
		return (float)sqrt((PointOne.x - PointTwo.x)*(PointOne.x - PointTwo.x) + 
			(PointOne.z - PointTwo.z)*(PointOne.z - PointTwo.z));

	}

	// Intersect a Plane with a Line or Ray, slightly different code
	BOOL IntersectPlane(const PLANE &Plane, const LINE &Line, D3DXVECTOR3 &IntersectPoint);
	BOOL IntersectPlane(const PLANE &Plane, const RAY &Ray, D3DXVECTOR3 &IntersectPoint);

	// main plane to plane for adding objects
	BOOL IntersectPlane(PLANE &Plane1, PLANE &Plane2);
	// calls triangle to triangle 8 times
	BOOL IntersectTriangle(const Triangle &T1, const Triangle &T2, LINE &Line, D3DXVECTOR3 &IntersectPoint);

	// helper function
	// the basis for all intersection functions
	BOOL IntersectTriangle( const Triangle &triangle, const RAY& ray);
	BOOL IntersectTriangle( const Triangle &triangle, const RAY& ray, D3DXVECTOR3 &IntersectPoint);
	BOOL IntersectTriangle( const Triangle &triangle, const LINE &Line, D3DXVECTOR3 &intersectPnt );
	// If a Plane is intersected with a line (finite length) instead of the SDK which used a ray model
	BOOL FindIntersection(D3DXVECTOR3 &Out, PLANE &Plane, D3DXVECTOR3 &v1, D3DXVECTOR3 &v2);

	// generates plane equation
	void GeneratePlane(PLANE &One);

	float abs(float in);

	void Normalize(float &in1, float &in2, float sum);

	// point in rectangle
	BOOL InRect(CPoint Point, CRect Rect);

	// for reducing angles to 0-360
	float Mod360(float angle);

	// base two math
	int Pwr2(int power);
	int Log2(int intput);


	UMath();
	virtual ~UMath();

};

// basic gaussian available for callback in the executefunction in the terrain manager
extern float Gaussian(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);

// a bit of an explination here for the 18 functions for speed rather then having one function 
// with if statements
// "a" means take sqrt(Dx2+Dz2)
// "b" means take fnc(Dx) * fnc(Dz)
// "c" means take fnc(Dx) + fnc(Dz)
// blank means take one period (one half period actually)
// R means go until radius hit then return an exit code
// LDR same as R except return value with linear decreasing factor
extern float Cos3Da(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Cos3Db(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Cos3Dc(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Cos3DRa(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Cos3DLDRa(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Cos3DRb(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Cos3DLDRb(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Cos3DRc(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Cos3DLDRc(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Sin3Da(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Sin3Db(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Sin3Dc(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Sin3DRa(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Sin3DLDRa(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Sin3DRb(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Sin3DLDRb(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Sin3DRc(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);
extern float Sin3DLDRc(const D3DXVECTOR3 &Center, const D3DXVECTOR3 &Current, const float Args[]);




extern UMath Math;

#endif // !defined(AFX_UMATH_H__C4435203_5511_47B6_867B_0E2A1FF0D695__INCLUDED_)
