// ViewManager.cpp: implementation of the ViewManager class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MapEditor.h"
#include "ViewManager.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ViewManager::ViewManager()
{
	ToolbarOffset = 26;

    WindowSize.left = 0;
    WindowSize.right = 800;
    WindowSize.top = 26;
    WindowSize.bottom = 688;  

	LockedView = -1;

	View4 = true;
	


}

ViewManager::~ViewManager()
{

}

void ViewManager::Create()
{
		// creates a new window and registers for it, to display the directX graphics
	char windowname[40]; 

    strcpy(windowname,AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		        ::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL));

    // Set the window's initial style
    m_dwWindowStyle = WS_BORDER
                      |WS_VISIBLE| WS_CHILD ;


	/*
    if (!Enabled)
    {
        m_dwWindowStyle &= ~WS_VISIBLE;
        m_dwWindowStyle |= WS_DISABLED;
    }*/



    // Create the render window 
    FrameWindow.CreateEx(WS_EX_TOPMOST  ,windowname,"Hello",m_dwWindowStyle,WindowSize,FramePtr,NULL,NULL);

    m_hWnd =FrameWindow.m_hWnd;

	this->m_bWindowed = true;
	this->m_bUseDepthBuffer = true;
  
	// calls the base class
    CD3DApplication::Create( AfxGetInstanceHandle() );
	
	for (int ix = 0; ix < MAXVIEWS; ix++)
	{
		theViews[ix].Renderer.m_pd3dDevice = this->m_pd3dDevice;
		theViews[ix].Renderer.FramePtr = this->FramePtr;
		theViews[ix].Renderer.WindowSize = this->WindowSize;
		theViews[ix].Renderer.m_d3dsdBackBuffer = this->m_d3dsdBackBuffer;
		theViews[ix].Renderer.m_d3dsdBackBuffer.Height = theViews[ix].Renderer.m_d3dsdBackBuffer.Height/2;
			theViews[ix].Renderer.m_d3dsdBackBuffer.Width = theViews[ix].Renderer.m_d3dsdBackBuffer.Width/2;

		theViews[ix].Renderer.Create();
		theViews[ix].Active = false;

	}
	WindowSize.bottom-=2;
	WindowSize.right-=2;
	// view[0] is top left
	theViews[0].ViewRect.top = 0;
	theViews[0].ViewRect.bottom = WindowSize.Height()/2;
	theViews[0].ViewRect.left = 0;
	theViews[0].ViewRect.right = WindowSize.Width()/2;
	theViews[0].Active = true;

	// top right
	theViews[1].ViewRect.top = 0;
	theViews[1].ViewRect.bottom = WindowSize.Height()/2;
	theViews[1].ViewRect.left = WindowSize.Width()/2;;
	theViews[1].ViewRect.right = WindowSize.Width();
	theViews[1].Active = true;

	// bottom left
	theViews[2].ViewRect.top = WindowSize.Height()/2;
	theViews[2].ViewRect.bottom = WindowSize.Height();
	theViews[2].ViewRect.left = 0;
	theViews[2].ViewRect.right = WindowSize.Width()/2;
	theViews[2].Active = true;

	// bottom right
	theViews[3].ViewRect.top =  WindowSize.Height()/2;
	theViews[3].ViewRect.bottom = WindowSize.Height();
	theViews[3].ViewRect.left = WindowSize.Width()/2;
	theViews[3].ViewRect.right = WindowSize.Width();
	theViews[3].Active = true;
	




}

void ViewManager::OnRender()
{
	Render3DEnvironment(); 

}



HRESULT ViewManager::Render()
{
	
	for (int ix = 0; ix < MAXVIEWS; ix++)
	{

		if (theViews[ix].Active)
		{
			D3DVIEWPORT8 temp;
			temp.X = theViews[ix].ViewRect.left;
			temp.Y = theViews[ix].ViewRect.top;
			temp.Width = theViews[ix].ViewRect.Width();
			temp.Height = theViews[ix].ViewRect.Height();
			temp.MinZ = 0.0f;
			temp.MaxZ = 1.0f;
			m_pd3dDevice->SetViewport(&temp);
			if( SUCCEEDED( m_pd3dDevice->BeginScene() ) )
			{
			theViews[ix].Renderer.Render();
			DrawRect(theViews[ix].ViewRect,0x000000);
				m_pd3dDevice->EndScene();

			}

		}
	}

	return 0;

}

//---------------------------------------------------------------------
// int GetView(CPoint Point)
// 
// Usage: To return the index of a view given a point
//
// Notes: returns -1 if no view is at that point
//---------------------------------------------------------------------
int ViewManager::GetView(CPoint Point)
{
	CRect x;
	// check if there is a locked view
	if (LockedView != -1)
		return LockedView;

	for (int ix = 0; ix < MAXVIEWS; ix++)
	{
		if (theViews[ix].Active)
		{
			CRect tRect = theViews[ix].ViewRect;
			if (tRect.top <= Point.y && Point.y <= tRect.bottom
				&& tRect.left <= Point.x && Point.x <= tRect.right)
				return ix;
		}
	}
	return -1;
}

//---------------------------------------------------------------------
// DrawRect(const RECT *pRect, DWORD color)
// 
// Usage: To draw a 2D rect on the screen, used for drawing borders
//
// Notes: Copied from Tom
//---------------------------------------------------------------------
void ViewManager::DrawRect(const RECT *pRect, DWORD color)
{

	VERTEX2D line[8];

	// Left side
	line[0].position.x = (float)pRect->left;
	line[0].position.y = (float)pRect->top;
	line[0].position.z = 0.0f;
	line[0].w = 1.0f;
	line[0].color = color;
	line[1].position.x = (float)pRect->left;
	line[1].position.y = (float)pRect->bottom;
	line[1].position.z = 0.0f;
	line[1].w = 1.0f;
	line[1].color = color;
	
	// Right side
	line[2].position.x = (float)pRect->right;
	line[2].position.y = (float)pRect->top;
	line[2].position.z = 0.0f;
	line[2].w = 1.0f;
	line[2].color = color;
	line[3].position.x = (float)pRect->right;
	line[3].position.y = (float)pRect->bottom;
	line[3].position.z = 0.0f;
	line[3].w = 1.0f;
	line[3].color = color;
	
	// Top Side
	line[4].position.x = (float)pRect->left;
	line[4].position.y = (float)pRect->top;
	line[4].position.z = 0.0f;
	line[4].w = 1.0f;
	line[4].color = color;
	line[5].position.x = (float)pRect->right;
	line[5].position.y = (float)pRect->top;
	line[5].position.z = 0.0f;
	line[5].w = 1.0f;
	line[5].color = color;
	
	// Bottom side
	line[6].position.x = (float)pRect->left;
	line[6].position.y = (float)pRect->bottom;
	line[6].position.z = 0.0f;
	line[6].w = 1.0f;
	line[6].color = color;
	line[7].position.x = (float)pRect->right;
	line[7].position.y = (float)pRect->bottom;
	line[7].position.z = 0.0f;
	line[7].w = 1.0f;
	line[7].color = color;

	m_pd3dDevice->SetVertexShader( VERTEX_TYPE2D );
	m_pd3dDevice->DrawPrimitiveUP(D3DPT_LINELIST,4,line,sizeof(VERTEX2D));

}

//---------------------------------------------------------------------
// OnLButtonDown(CPoint Point, DWORD nFlags)
// 
// Usage: Called by view class message handler
//
//---------------------------------------------------------------------
void ViewManager::OnLButtonDown(UINT nFlags, CPoint Point)
{
	int Index = GetView(Point);
	// check if valid
	if (Index == -1)
		return;

	// lock the view
	LockedView = Index;
	theViews[Index].Renderer.RCSetZoomPoint(Point);

}

//---------------------------------------------------------------------
// OnRButtonDown(CPoint Point, DWORD nFlags)
// 
// Usage: Called by view class message handler
//
//---------------------------------------------------------------------
void ViewManager::OnRButtonDown(UINT nFlags, CPoint Point)
{
	int Index = GetView(Point);
	// check if valid
	if (Index == -1)
		return;

	// lock the view
	LockedView = Index;
	theViews[Index].Renderer.RCSetZoomPoint(Point);

}

//---------------------------------------------------------------------
// OnMButtonDown(CPoint Point, DWORD nFlags)
// 
// Usage: Called by view class message handler
//
//---------------------------------------------------------------------
void ViewManager::OnMButtonDown(UINT nFlags, CPoint Point)
{
	int Index = GetView(Point);
	// check if valid
	if (Index == -1)
		return;

	// lock the view
	LockedView = Index;
	theViews[Index].Renderer.RCSetZoomPoint(Point);

}

//---------------------------------------------------------------------
// OnLButtonUp(CPoint Point, DWORD nFlags)
// 
// Usage: Called by view class message handler
//
//---------------------------------------------------------------------
void ViewManager::OnLButtonUp(UINT nFlags, CPoint Point)
{
	if (!(nFlags & MK_CONTROL))
	{
		int Index = GetView(Point);
		// check if valid
		if (Index == -1)
			return;

		// ignore input point, not accurate, don't know why
		POINT ptCursor;
		GetCursorPos( &ptCursor );
	    ScreenToClient( FramePtr->m_hWnd, &ptCursor );

		ptCursor.x = ptCursor.x - theViews[Index].ViewRect.left;
		ptCursor.y = ptCursor.y - theViews[Index].ViewRect.top-ToolbarOffset;
				
		if (MK_SHIFT & nFlags) // shift toggles add to group
			theViews[Index].Renderer.RCSelectObject(ptCursor,true);  
		else
			theViews[Index].Renderer.RCSelectObject(ptCursor,false);   
	}

	// unlock the view
	LockedView = -1;

}

//---------------------------------------------------------------------
// OnRButtonUp(CPoint Point, DWORD nFlags)
// 
// Usage: Called by view class message handler
//
//---------------------------------------------------------------------
void ViewManager::OnRButtonUp(UINT nFlags, CPoint Point)
{
	// unlock the view
	LockedView = -1;

}

//---------------------------------------------------------------------
// OnMButtonUp(CPoint Point, DWORD nFlags)
// 
// Usage: Called by view class message handler
//
//---------------------------------------------------------------------
void ViewManager::OnMButtonUp(UINT nFlags, CPoint Point)
{
	// unlock the view
	LockedView = -1;

}

//---------------------------------------------------------------------
// OnMouseMove(UINT nFlags, CPoint Point)
// 
// Usage: Called by view class message handler
//
//---------------------------------------------------------------------
void ViewManager::OnMouseMove(UINT nFlags, CPoint Point)
{
//	int blah = MK_MBUTTON;
	if (nFlags & MK_CONTROL)
	{
		int Index = GetView(Point);
		// check if valid
		if (Index == -1)
			return;

		theViews[Index].Renderer.OnMouseMove(nFlags, Point);   
	} 
}

//---------------------------------------------------------------------
// OnToggle4View()
// 
// Usage: Toggles between 1 view and 4 views
//
//---------------------------------------------------------------------
void ViewManager::OnToggle4View()
{
	if (View4)
	{
		View4 = false;
		theViews[1].Active = false;
		theViews[2].Active = false;
		theViews[3].Active = false;
		
		theViews[0].Renderer.m_d3dsdBackBuffer.Height = m_d3dsdBackBuffer.Height;
		theViews[0].Renderer.m_d3dsdBackBuffer.Width = m_d3dsdBackBuffer.Width;		
		theViews[0].ViewRect.top = 0;
		theViews[0].ViewRect.bottom = WindowSize.Height();
		theViews[0].ViewRect.left = 0;
		theViews[0].ViewRect.right = WindowSize.Width();
	}
	else
	{
		View4 = true;

		theViews[1].Active = true;
		theViews[2].Active = true;
		theViews[3].Active = true;
		
		theViews[0].Renderer.m_d3dsdBackBuffer.Height = theViews[0].Renderer.m_d3dsdBackBuffer.Height/2;
		theViews[0].Renderer.m_d3dsdBackBuffer.Width = theViews[0].Renderer.m_d3dsdBackBuffer.Width/2;		
		theViews[0].ViewRect.top = 0;
		theViews[0].ViewRect.bottom = WindowSize.Height()/2;
		theViews[0].ViewRect.left = 0;
		theViews[0].ViewRect.right = WindowSize.Width()/2;
	}

}

//---------------------------------------------------------------------
// SetGridDepth(int GridDepth)
// 
// Usage: Sets the grid depth to display
//
//---------------------------------------------------------------------
void ViewManager::SetGridDepth(int GridDepth)
{
	this->GridDepth = GridDepth;
	for (int ix = 0; ix < MAXVIEWS; ix++)
	{
		theViews[ix].Renderer.GridDepth = GridDepth;
	}
}
